/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.TypeDeserializer;
import org.codehaus.jackson.type.JavaType;
import org.codehaus.jackson.util.InternCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SettableBeanProperty {
    final String _propName;
    final JavaType _type;
    protected JsonDeserializer<Object> _valueDeserializer;
    protected TypeDeserializer _valueTypeDeserializer;
    protected Object _nullValue;

    protected SettableBeanProperty(String propName, JavaType type, TypeDeserializer typeDeser) {
        this._propName = propName == null || propName.length() == 0 ? "" : InternCache.instance.intern(propName);
        this._type = type;
        this._valueTypeDeserializer = typeDeser;
    }

    public void setValueDeserializer(JsonDeserializer<Object> deser) {
        if (this._valueDeserializer != null) {
            throw new IllegalStateException("Already had assigned deserializer for property '" + this._propName + "' (class " + this.getDeclaringClass().getName() + ")");
        }
        this._valueDeserializer = deser;
        this._nullValue = this._valueDeserializer.getNullValue();
    }

    protected abstract Class<?> getDeclaringClass();

    public String getPropertyName() {
        return this._propName;
    }

    public JavaType getType() {
        return this._type;
    }

    public boolean hasValueDeserializer() {
        return this._valueDeserializer != null;
    }

    public int getCreatorIndex() {
        return -1;
    }

    public abstract void deserializeAndSet(JsonParser var1, DeserializationContext var2, Object var3) throws IOException, JsonProcessingException;

    public abstract void set(Object var1, Object var2) throws IOException;

    public final Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NULL) {
            return this._nullValue;
        }
        if (this._valueTypeDeserializer != null) {
            return this._valueDeserializer.deserializeWithType(jp, ctxt, this._valueTypeDeserializer);
        }
        return this._valueDeserializer.deserialize(jp, ctxt);
    }

    protected void _throwAsIOE(Exception e, Object value) throws IOException {
        if (e instanceof IllegalArgumentException) {
            String actType = value == null ? "[NULL]" : value.getClass().getName();
            StringBuilder msg = new StringBuilder("Problem deserializing property '").append(this.getPropertyName());
            msg.append("' (expected type: ").append(this.getType());
            msg.append("; actual type: ").append(actType).append(")");
            String origMsg = e.getMessage();
            if (origMsg != null) {
                msg.append(", problem: ").append(origMsg);
            } else {
                msg.append(" (no error message provided)");
            }
            throw new JsonMappingException(msg.toString(), null, e);
        }
        this._throwAsIOE(e);
    }

    protected IOException _throwAsIOE(Exception e) throws IOException {
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        Throwable th = e;
        while (th.getCause() != null) {
            th = th.getCause();
        }
        throw new JsonMappingException(th.getMessage(), null, th);
    }

    public String toString() {
        return "[property '" + this._propName + "']";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CreatorProperty
    extends SettableBeanProperty {
        final Class<?> _declaringClass;
        final int _index;

        public CreatorProperty(String propName, JavaType type, TypeDeserializer typeDeser, Class<?> declaringClass, int index) {
            super(propName, type, typeDeser);
            this._declaringClass = declaringClass;
            this._index = index;
        }

        @Override
        public int getCreatorIndex() {
            return this._index;
        }

        @Override
        protected Class<?> getDeclaringClass() {
            return this._declaringClass;
        }

        @Override
        public void deserializeAndSet(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException, JsonProcessingException {
            this.set(instance, this.deserialize(jp, ctxt));
        }

        @Override
        public void set(Object instance, Object value) throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FieldProperty
    extends SettableBeanProperty {
        protected final Field _field;

        public FieldProperty(String propName, JavaType type, TypeDeserializer typeDeser, Field f) {
            super(propName, type, typeDeser);
            this._field = f;
        }

        @Override
        protected Class<?> getDeclaringClass() {
            return this._field.getDeclaringClass();
        }

        @Override
        public void deserializeAndSet(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException, JsonProcessingException {
            this.set(instance, this.deserialize(jp, ctxt));
        }

        @Override
        public final void set(Object instance, Object value) throws IOException {
            try {
                this._field.set(instance, value);
            }
            catch (Exception e) {
                this._throwAsIOE(e, value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SetterlessProperty
    extends SettableBeanProperty {
        protected final Method _getter;

        public SetterlessProperty(String propName, JavaType type, TypeDeserializer typeDeser, Method getter) {
            super(propName, type, typeDeser);
            this._getter = getter;
        }

        @Override
        protected Class<?> getDeclaringClass() {
            return this._getter.getDeclaringClass();
        }

        @Override
        public final void deserializeAndSet(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException, JsonProcessingException {
            Object toModify;
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.VALUE_NULL) {
                return;
            }
            try {
                toModify = this._getter.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                this._throwAsIOE(e);
                return;
            }
            if (toModify == null) {
                throw new JsonMappingException("Problem deserializing 'setterless' property '" + this.getPropertyName() + "': get method returned null");
            }
            this._valueDeserializer.deserialize(jp, ctxt, toModify);
        }

        @Override
        public final void set(Object instance, Object value) throws IOException {
            throw new UnsupportedOperationException("Should never call 'set' on setterless property");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MethodProperty
    extends SettableBeanProperty {
        protected final Method _setter;

        public MethodProperty(String propName, JavaType type, TypeDeserializer typeDeser, Method setter) {
            super(propName, type, typeDeser);
            this._setter = setter;
        }

        @Override
        protected Class<?> getDeclaringClass() {
            return this._setter.getDeclaringClass();
        }

        @Override
        public void deserializeAndSet(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException, JsonProcessingException {
            this.set(instance, this.deserialize(jp, ctxt));
        }

        @Override
        public final void set(Object instance, Object value) throws IOException {
            try {
                this._setter.invoke(instance, value);
            }
            catch (Exception e) {
                this._throwAsIOE(e, value);
            }
        }
    }
}

