/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class SettingsConfig
implements ToXContentObject {
    private static final ParseField MAX_PAGE_SEARCH_SIZE = new ParseField("max_page_search_size", new String[0]);
    private static final ParseField DOCS_PER_SECOND = new ParseField("docs_per_second", new String[0]);
    private static final ParseField DATES_AS_EPOCH_MILLIS = new ParseField("dates_as_epoch_millis", new String[0]);
    private static final int DEFAULT_MAX_PAGE_SEARCH_SIZE = -1;
    private static final float DEFAULT_DOCS_PER_SECOND = -1.0f;
    private static final int DEFAULT_DATES_AS_EPOCH_MILLIS = -1;
    private final Integer maxPageSearchSize;
    private final Float docsPerSecond;
    private final Integer datesAsEpochMillis;
    private static final ConstructingObjectParser<SettingsConfig, Void> PARSER = new ConstructingObjectParser("settings_config", true, args -> new SettingsConfig((Integer)args[0], (Float)args[1], (Integer)args[2]));

    public static SettingsConfig fromXContent(XContentParser parser) {
        return (SettingsConfig)PARSER.apply(parser, null);
    }

    SettingsConfig(Integer maxPageSearchSize, Float docsPerSecond, Integer datesAsEpochMillis) {
        this.maxPageSearchSize = maxPageSearchSize;
        this.docsPerSecond = docsPerSecond;
        this.datesAsEpochMillis = datesAsEpochMillis;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.maxPageSearchSize != null) {
            if (this.maxPageSearchSize.equals(-1)) {
                builder.field(MAX_PAGE_SEARCH_SIZE.getPreferredName(), (Integer)null);
            } else {
                builder.field(MAX_PAGE_SEARCH_SIZE.getPreferredName(), this.maxPageSearchSize);
            }
        }
        if (this.docsPerSecond != null) {
            if (this.docsPerSecond.equals(Float.valueOf(-1.0f))) {
                builder.field(DOCS_PER_SECOND.getPreferredName(), (Float)null);
            } else {
                builder.field(DOCS_PER_SECOND.getPreferredName(), this.docsPerSecond);
            }
        }
        if (this.datesAsEpochMillis != null) {
            if (this.datesAsEpochMillis.equals(-1)) {
                builder.field(DATES_AS_EPOCH_MILLIS.getPreferredName(), (Boolean)null);
            } else {
                builder.field(DATES_AS_EPOCH_MILLIS.getPreferredName(), this.datesAsEpochMillis > 0);
            }
        }
        builder.endObject();
        return builder;
    }

    public Integer getMaxPageSearchSize() {
        return this.maxPageSearchSize;
    }

    public Float getDocsPerSecond() {
        return this.docsPerSecond;
    }

    public Boolean getDatesAsEpochMillis() {
        return this.datesAsEpochMillis != null ? Boolean.valueOf(this.datesAsEpochMillis > 0) : null;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        SettingsConfig that = (SettingsConfig)other;
        return Objects.equals(this.maxPageSearchSize, that.maxPageSearchSize) && Objects.equals(this.docsPerSecond, that.docsPerSecond) && Objects.equals(this.datesAsEpochMillis, that.datesAsEpochMillis);
    }

    public int hashCode() {
        return Objects.hash(this.maxPageSearchSize, this.docsPerSecond, this.datesAsEpochMillis);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareIntOrNull(ConstructingObjectParser.optionalConstructorArg(), -1, MAX_PAGE_SEARCH_SIZE);
        PARSER.declareFloatOrNull(ConstructingObjectParser.optionalConstructorArg(), -1.0f, DOCS_PER_SECOND);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> p.currentToken() == XContentParser.Token.VALUE_NULL ? -1 : (p.booleanValue() ? 1 : 0), DATES_AS_EPOCH_MILLIS, ObjectParser.ValueType.BOOLEAN_OR_NULL);
    }

    public static class Builder {
        private Integer maxPageSearchSize;
        private Float docsPerSecond;
        private Integer datesAsEpochMillis;

        public Builder setMaxPageSearchSize(Integer maxPageSearchSize) {
            this.maxPageSearchSize = maxPageSearchSize == null ? -1 : maxPageSearchSize;
            return this;
        }

        public Builder setRequestsPerSecond(Float docsPerSecond) {
            this.docsPerSecond = Float.valueOf(docsPerSecond == null ? -1.0f : docsPerSecond.floatValue());
            return this;
        }

        public Builder setDatesAsEpochMillis(Boolean datesAsEpochMillis) {
            this.datesAsEpochMillis = datesAsEpochMillis == null ? -1 : (datesAsEpochMillis != false ? 1 : 0);
            return this;
        }

        public SettingsConfig build() {
            return new SettingsConfig(this.maxPageSearchSize, this.docsPerSecond, this.datesAsEpochMillis);
        }
    }
}

