/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ast;

import com.oracle.graal.python.builtins.modules.ast.AstState;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.pegparser.sst.CmpOpTy;
import com.oracle.graal.python.pegparser.sst.ConstantValue;
import com.oracle.graal.python.pegparser.sst.SSTNode;
import com.oracle.graal.python.pegparser.sst.SSTreeVisitor;
import com.oracle.graal.python.pegparser.tokenizer.SourceRange;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.strings.TruffleString;

abstract class Sst2ObjVisitorBase
implements SSTreeVisitor<Object> {
    final PythonObjectFactory factory = PythonObjectFactory.getUncached();

    Sst2ObjVisitorBase() {
    }

    static int visitNullable(int i) {
        return i;
    }

    static Object visitNullable(String str) {
        return str == null ? PNone.NONE : PythonUtils.toTruffleStringUncached(str);
    }

    Object visitNullableStringOrByteArray(Object o) {
        return o == null ? PNone.NONE : this.visitNonNullStringOrByteArray(o);
    }

    final Object visitNullable(CmpOpTy op) {
        return op == null ? PNone.NONE : this.visitNonNull(op);
    }

    final Object visitNullable(SSTNode node) {
        return node == null ? PNone.NONE : node.accept(this);
    }

    static int visitNonNull(boolean i) {
        return i ? 1 : 0;
    }

    static int visitNonNull(int i) {
        return i;
    }

    static TruffleString visitNonNull(String str) {
        return PythonUtils.toTruffleStringUncached(str);
    }

    Object visitNonNullStringOrByteArray(Object o) {
        if (o instanceof String) {
            return PythonUtils.toTruffleStringUncached((String)o);
        }
        assert (o instanceof byte[]);
        return this.factory.createBytes((byte[])o);
    }

    final Object visitNonNull(ConstantValue v) {
        return PythonUtils.pythonObjectFromConstantValue(v, this.factory);
    }

    abstract Object visitNonNull(CmpOpTy var1);

    final Object visitNonNull(SSTNode node) {
        return node.accept(this);
    }

    final PList seq2List(String[] seq) {
        if (seq == null || seq.length == 0) {
            return this.factory.createList();
        }
        Object[] objs = new Object[seq.length];
        for (int i = 0; i < objs.length; ++i) {
            objs[i] = Sst2ObjVisitorBase.visitNullable(seq[i]);
        }
        return this.factory.createList(objs);
    }

    final PList seq2List(CmpOpTy[] seq) {
        if (seq == null || seq.length == 0) {
            return this.factory.createList();
        }
        Object[] objs = new Object[seq.length];
        for (int i = 0; i < objs.length; ++i) {
            objs[i] = this.visitNullable(seq[i]);
        }
        return this.factory.createList(objs);
    }

    final PList seq2List(SSTNode[] seq) {
        if (seq == null || seq.length == 0) {
            return this.factory.createList();
        }
        Object[] objs = new Object[seq.length];
        for (int i = 0; i < objs.length; ++i) {
            objs[i] = this.visitNullable(seq[i]);
        }
        return this.factory.createList(objs);
    }

    static final void fillSourceRangeAttributes(PythonObject o, SourceRange sourceRange) {
        o.setAttribute(AstState.T_F_LINENO, sourceRange.startLine);
        o.setAttribute(AstState.T_F_COL_OFFSET, sourceRange.startColumn);
        o.setAttribute(AstState.T_F_END_LINENO, sourceRange.endLine);
        o.setAttribute(AstState.T_F_END_COL_OFFSET, sourceRange.endColumn);
    }
}

