/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.bytes;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.BytesCommonBuiltins;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.function.builtins.clinic.IndexConversionNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.JavaIntConversionNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ReadableBufferConversionNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.SliceIndexConversionNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.TruffleStringConverterWithDefaultValueNode;

public class BytesCommonBuiltinsClinicProviders {

    public static final class ReplaceNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final ReplaceNodeClinicProviderGen INSTANCE = new ReplaceNodeClinicProviderGen();

        private ReplaceNodeClinicProviderGen() {
            super(1, 9, 1, 1, 14);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 1: {
                    return ReadableBufferConversionNode.create(false);
                }
                case 2: {
                    return ReadableBufferConversionNode.create(false);
                }
                case 3: {
                    return BytesCommonBuiltins.ExpectIntNode.create(Integer.MAX_VALUE);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class IsTitleNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final IsTitleNodeClinicProviderGen INSTANCE = new IsTitleNodeClinicProviderGen();

        private IsTitleNodeClinicProviderGen() {
            super(0, 0, 0, 0, 1);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 0) {
                return ReadableBufferConversionNode.create(false);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class CountNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final CountNodeClinicProviderGen INSTANCE = new CountNodeClinicProviderGen();

        private CountNodeClinicProviderGen() {
            super(3, 15, 3, 3, 12);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 2: {
                    return SliceIndexConversionNode.create(0, true);
                }
                case 3: {
                    return SliceIndexConversionNode.create(Integer.MAX_VALUE, true);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class DecodeNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final DecodeNodeClinicProviderGen INSTANCE = new DecodeNodeClinicProviderGen();

        private DecodeNodeClinicProviderGen() {
            super(1, 1, 1, 1, 6);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 1: {
                    return TruffleStringConverterWithDefaultValueNode.create("decode", StringLiterals.T_UTF8, false);
                }
                case 2: {
                    return TruffleStringConverterWithDefaultValueNode.create("decode", StringLiterals.T_STRICT, false);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class HexNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final HexNodeClinicProviderGen INSTANCE = new HexNodeClinicProviderGen();

        private HexNodeClinicProviderGen() {
            super(1, 5, 1, 1, 6);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 1: {
                    return BytesCommonBuiltins.SepExpectByteNode.create(PNone.NO_VALUE);
                }
                case 2: {
                    return BytesCommonBuiltins.ExpectIntNode.create(1);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class RIndexNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final RIndexNodeClinicProviderGen INSTANCE = new RIndexNodeClinicProviderGen();

        private RIndexNodeClinicProviderGen() {
            super(3, 15, 3, 3, 12);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 2: {
                    return SliceIndexConversionNode.create(0, true);
                }
                case 3: {
                    return SliceIndexConversionNode.create(Integer.MAX_VALUE, true);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class IsLowerNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final IsLowerNodeClinicProviderGen INSTANCE = new IsLowerNodeClinicProviderGen();

        private IsLowerNodeClinicProviderGen() {
            super(0, 0, 0, 0, 1);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 0) {
                return ReadableBufferConversionNode.create(false);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class IsUpperNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final IsUpperNodeClinicProviderGen INSTANCE = new IsUpperNodeClinicProviderGen();

        private IsUpperNodeClinicProviderGen() {
            super(0, 0, 0, 0, 1);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 0) {
                return ReadableBufferConversionNode.create(false);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class IsAlphaNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final IsAlphaNodeClinicProviderGen INSTANCE = new IsAlphaNodeClinicProviderGen();

        private IsAlphaNodeClinicProviderGen() {
            super(0, 0, 0, 0, 1);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 0) {
                return ReadableBufferConversionNode.create(false);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class RFindNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final RFindNodeClinicProviderGen INSTANCE = new RFindNodeClinicProviderGen();

        private RFindNodeClinicProviderGen() {
            super(3, 15, 3, 3, 12);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 2: {
                    return SliceIndexConversionNode.create(0, true);
                }
                case 3: {
                    return SliceIndexConversionNode.create(Integer.MAX_VALUE, true);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class IsDigitNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final IsDigitNodeClinicProviderGen INSTANCE = new IsDigitNodeClinicProviderGen();

        private IsDigitNodeClinicProviderGen() {
            super(0, 0, 0, 0, 1);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 0) {
                return ReadableBufferConversionNode.create(false);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class IsAlnumNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final IsAlnumNodeClinicProviderGen INSTANCE = new IsAlnumNodeClinicProviderGen();

        private IsAlnumNodeClinicProviderGen() {
            super(0, 0, 0, 0, 1);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 0) {
                return ReadableBufferConversionNode.create(false);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class SplitNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final SplitNodeClinicProviderGen INSTANCE = new SplitNodeClinicProviderGen();

        private SplitNodeClinicProviderGen() {
            super(1, 5, 1, 1, 6);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 1: {
                    return BytesCommonBuiltins.ExpectByteLikeNode.create(BytesCommonBuiltins.AbstractSplitNode.WHITESPACE);
                }
                case 2: {
                    return BytesCommonBuiltins.ExpectIntNode.create(Integer.MAX_VALUE);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class ZFillNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final ZFillNodeClinicProviderGen INSTANCE = new ZFillNodeClinicProviderGen();

        private ZFillNodeClinicProviderGen() {
            super(1, 3, 1, 1, 2);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 1) {
                return IndexConversionNode.create(false);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class RSplitNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final RSplitNodeClinicProviderGen INSTANCE = new RSplitNodeClinicProviderGen();

        private RSplitNodeClinicProviderGen() {
            super(1, 5, 1, 1, 6);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 1: {
                    return BytesCommonBuiltins.ExpectByteLikeNode.create(BytesCommonBuiltins.AbstractSplitNode.WHITESPACE);
                }
                case 2: {
                    return BytesCommonBuiltins.ExpectIntNode.create(Integer.MAX_VALUE);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class FindNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final FindNodeClinicProviderGen INSTANCE = new FindNodeClinicProviderGen();

        private FindNodeClinicProviderGen() {
            super(3, 15, 3, 3, 12);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 2: {
                    return SliceIndexConversionNode.create(0, true);
                }
                case 3: {
                    return SliceIndexConversionNode.create(Integer.MAX_VALUE, true);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class EndsWithNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final EndsWithNodeClinicProviderGen INSTANCE = new EndsWithNodeClinicProviderGen();

        private EndsWithNodeClinicProviderGen() {
            super(3, 15, 3, 3, 12);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 2: {
                    return SliceIndexConversionNode.create(0, true);
                }
                case 3: {
                    return SliceIndexConversionNode.create(Integer.MAX_VALUE, true);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class ExpandTabsNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final ExpandTabsNodeClinicProviderGen INSTANCE = new ExpandTabsNodeClinicProviderGen();

        private ExpandTabsNodeClinicProviderGen() {
            super(1, 3, 1, 1, 2);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 1) {
                return JavaIntConversionNode.create(8, false);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class StartsWithNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final StartsWithNodeClinicProviderGen INSTANCE = new StartsWithNodeClinicProviderGen();

        private StartsWithNodeClinicProviderGen() {
            super(3, 15, 3, 3, 12);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 2: {
                    return SliceIndexConversionNode.create(0, true);
                }
                case 3: {
                    return SliceIndexConversionNode.create(Integer.MAX_VALUE, true);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class IsSpaceNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final IsSpaceNodeClinicProviderGen INSTANCE = new IsSpaceNodeClinicProviderGen();

        private IsSpaceNodeClinicProviderGen() {
            super(0, 0, 0, 0, 1);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 0) {
                return ReadableBufferConversionNode.create(false);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class IsASCIINodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final IsASCIINodeClinicProviderGen INSTANCE = new IsASCIINodeClinicProviderGen();

        private IsASCIINodeClinicProviderGen() {
            super(0, 0, 0, 0, 1);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 0) {
                return ReadableBufferConversionNode.create(false);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class IndexNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final IndexNodeClinicProviderGen INSTANCE = new IndexNodeClinicProviderGen();

        private IndexNodeClinicProviderGen() {
            super(3, 15, 3, 3, 12);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 2: {
                    return SliceIndexConversionNode.create(0, true);
                }
                case 3: {
                    return SliceIndexConversionNode.create(Integer.MAX_VALUE, true);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }
}

