/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.common;

import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

public abstract class CArrayWrappers {
    public static final Unsafe UNSAFE = PythonUtils.initUnsafe();
    private static final long SIZEOF_INT64 = 8L;

    @CompilerDirectives.TruffleBoundary
    public static long byteArrayToNativeInt8(byte[] data, boolean writeNullTerminator) {
        int size = data.length * 1;
        long ptr = UNSAFE.allocateMemory(size + (writeNullTerminator ? 1 : 0));
        UNSAFE.copyMemory(data, Unsafe.ARRAY_BYTE_BASE_OFFSET, null, ptr, size);
        if (writeNullTerminator) {
            UNSAFE.putByte(ptr + (long)size, (byte)0);
        }
        return ptr;
    }

    @CompilerDirectives.TruffleBoundary
    public static long intArrayToNativeInt32(int[] data) {
        int size = data.length * 4;
        long ptr = UNSAFE.allocateMemory(size);
        UNSAFE.copyMemory(data, Unsafe.ARRAY_INT_BASE_OFFSET, null, ptr, size);
        return ptr;
    }

    public static long intArrayToNativeInt64(int[] data) {
        long size = (long)data.length * 8L;
        long ptr = CArrayWrappers.allocateBoundary(size);
        for (int i = 0; i < data.length; ++i) {
            UNSAFE.putLong(ptr + (long)i * 8L, data[i]);
        }
        return ptr;
    }

    public static long stringToNativeUtf8Bytes(TruffleString string, TruffleString.SwitchEncodingNode switchEncodingNode, TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
        TruffleString utf8 = switchEncodingNode.execute((AbstractTruffleString)string, TruffleString.Encoding.UTF_8);
        byte[] data = new byte[utf8.byteLength(TruffleString.Encoding.UTF_8)];
        copyToByteArrayNode.execute((AbstractTruffleString)utf8, 0, data, 0, data.length, TruffleString.Encoding.UTF_8);
        return CArrayWrappers.byteArrayToNativeInt8(data, true);
    }

    @CompilerDirectives.TruffleBoundary
    private static long allocateBoundary(long size) {
        return UNSAFE.allocateMemory(size);
    }

    @CompilerDirectives.TruffleBoundary
    private static void freeBoundary(long address) {
        UNSAFE.freeMemory(address);
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class CIntArrayWrapper
    extends CArrayWrapper {
        public CIntArrayWrapper(int[] delegate) {
            super(delegate);
        }

        public int[] getIntArray() {
            return (int[])this.getDelegate();
        }

        @ExportMessage
        long getArraySize() {
            return this.getIntArray().length;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object readArrayElement(long index, @Cached.Exclusive @Cached GilNode gil) throws InvalidArrayIndexException {
            boolean mustRelease = gil.acquire();
            try {
                int idx = PInt.intValueExact(index);
                int[] arr = this.getIntArray();
                if (idx >= 0 && idx < arr.length) {
                    Integer n = arr[idx];
                    return n;
                }
            }
            catch (OverflowException overflowException) {
            }
            finally {
                gil.release(mustRelease);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw InvalidArrayIndexException.create((long)index);
        }

        @ExportMessage
        boolean isArrayElementReadable(long identifier) {
            return 0L <= identifier && identifier < this.getArraySize();
        }

        @ExportMessage
        void toNative(@Bind(value="$node") Node node) {
            if (!PythonContext.get(node).isNativeAccessAllowed()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new RuntimeException(ErrorMessages.NATIVE_ACCESS_NOT_ALLOWED.toJavaStringUncached());
            }
            if (!this.isNative()) {
                this.setNativePointer(CArrayWrappers.intArrayToNativeInt32(this.getIntArray()));
            }
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class CByteArrayWrapper
    extends CArrayWrapper {
        public CByteArrayWrapper(byte[] delegate) {
            super(delegate);
        }

        public byte[] getByteArray() {
            return (byte[])this.getDelegate();
        }

        @ExportMessage
        boolean hasBufferElements() {
            return true;
        }

        @ExportMessage.Repeat(value={@ExportMessage, @ExportMessage(name="getArraySize")})
        long getBufferSize() {
            return this.getByteArray().length + 1;
        }

        @ExportMessage
        byte readBufferByte(long byteOffset) throws InvalidBufferOffsetException {
            byte[] bytes = this.getByteArray();
            if (byteOffset == (long)bytes.length) {
                return 0;
            }
            try {
                return bytes[(int)byteOffset];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)bytes.length);
            }
        }

        @ExportMessage
        short readBufferShort(ByteOrder order, long byteOffset) throws InvalidBufferOffsetException {
            try {
                return PythonUtils.byteArraySupport(order).getShort(this.getByteArray(), byteOffset);
            }
            catch (IndexOutOfBoundsException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)this.getByteArray().length);
            }
        }

        @ExportMessage
        int readBufferInt(ByteOrder order, long byteOffset) throws InvalidBufferOffsetException {
            try {
                return PythonUtils.byteArraySupport(order).getInt(this.getByteArray(), byteOffset);
            }
            catch (IndexOutOfBoundsException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)this.getByteArray().length);
            }
        }

        @ExportMessage
        long readBufferLong(ByteOrder order, long byteOffset) throws InvalidBufferOffsetException {
            try {
                return PythonUtils.byteArraySupport(order).getLong(this.getByteArray(), byteOffset);
            }
            catch (IndexOutOfBoundsException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)this.getByteArray().length);
            }
        }

        @ExportMessage
        float readBufferFloat(ByteOrder order, long byteOffset) throws InvalidBufferOffsetException {
            return Float.intBitsToFloat(this.readBufferInt(order, byteOffset));
        }

        @ExportMessage
        double readBufferDouble(ByteOrder order, long byteOffset) throws InvalidBufferOffsetException {
            return Double.longBitsToDouble(this.readBufferLong(order, byteOffset));
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @ExportMessage
        Object readArrayElement(long index, @Cached.Exclusive @Cached GilNode gil) throws InvalidArrayIndexException {
            block6: {
                byte[] arr;
                int idx;
                boolean mustRelease = gil.acquire();
                try {
                    idx = PInt.intValueExact(index);
                    arr = this.getByteArray();
                    if (idx >= 0 && idx < arr.length) {
                        Byte by = arr[idx];
                        gil.release(mustRelease);
                        return by;
                    }
                }
                catch (OverflowException overflowException) {
                    // empty catch block
                    break block6;
                }
                catch (Throwable throwable) {
                    gil.release(mustRelease);
                    throw throwable;
                }
                {
                    if (idx != arr.length) break block6;
                    Byte by = 0;
                    gil.release(mustRelease);
                    return by;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw InvalidArrayIndexException.create((long)index);
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return 0L <= index && index < this.getBufferSize();
        }

        @ExportMessage
        void toNative(@Bind(value="$node") Node node) {
            if (!PythonContext.get(node).isNativeAccessAllowed()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new RuntimeException(ErrorMessages.NATIVE_ACCESS_NOT_ALLOWED.toJavaStringUncached());
            }
            if (!this.isNative()) {
                this.setNativePointer(CArrayWrappers.byteArrayToNativeInt8(this.getByteArray(), true));
            }
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class CStringWrapper
    extends CArrayWrapper {
        private TruffleString.Encoding encoding;

        public CStringWrapper(TruffleString delegate, TruffleString.Encoding encoding) {
            super(delegate);
            this.encoding = encoding;
            assert (delegate.isValidUncached(encoding));
        }

        public TruffleString getString() {
            return (TruffleString)this.getDelegate();
        }

        @ExportMessage
        long getArraySize() {
            return this.getString().byteLength(this.encoding) + 1;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        byte readArrayElement(long index, @CachedLibrary(value="this") InteropLibrary thisLib) throws InvalidArrayIndexException, UnsupportedMessageException {
            try {
                return thisLib.readBufferByte((Object)this, index);
            }
            catch (InvalidBufferOffsetException e) {
                throw InvalidArrayIndexException.create((long)index);
            }
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return 0L <= index && index <= (long)this.getString().byteLength(this.encoding);
        }

        @ExportMessage
        void toNative(@Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
            if (!PythonContext.get((Node)switchEncodingNode).isNativeAccessAllowed()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new RuntimeException(ErrorMessages.NATIVE_ACCESS_NOT_ALLOWED.toJavaStringUncached());
            }
            if (!this.isNative()) {
                this.setNativePointer(CArrayWrappers.stringToNativeUtf8Bytes(this.getString(), switchEncodingNode, copyToByteArrayNode));
            }
        }

        @ExportMessage
        boolean hasBufferElements() {
            return true;
        }

        @ExportMessage
        long getBufferSize() {
            return this.getString().byteLength(this.encoding) + 1;
        }

        @ExportMessage
        byte readBufferByte(long byteOffset, @Cached TruffleString.ReadByteNode readByteNode) throws InvalidBufferOffsetException {
            TruffleString s = this.getString();
            int len = s.byteLength(this.encoding);
            if (byteOffset >= 0L && byteOffset < (long)len) {
                return (byte)readByteNode.execute((AbstractTruffleString)s, (int)byteOffset, this.encoding);
            }
            if (byteOffset == (long)len) {
                return 0;
            }
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)len);
        }

        @ExportMessage
        short readBufferShort(ByteOrder byteOrder, long byteOffset, @CachedLibrary(value="this") InteropLibrary thisLib) throws UnsupportedMessageException, InvalidBufferOffsetException {
            byte b1 = thisLib.readBufferByte((Object)this, byteOffset);
            byte b2 = thisLib.readBufferByte((Object)this, byteOffset + 1L);
            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                return (short)((b2 & 0xFF) << 8 | b1 & 0xFF);
            }
            return (short)((b1 & 0xFF) << 8 | b2 & 0xFF);
        }

        @ExportMessage
        int readBufferInt(ByteOrder byteOrder, long byteOffset, @CachedLibrary(value="this") InteropLibrary thisLib) throws UnsupportedMessageException, InvalidBufferOffsetException {
            byte b1 = thisLib.readBufferByte((Object)this, byteOffset);
            byte b2 = thisLib.readBufferByte((Object)this, byteOffset + 1L);
            byte b3 = thisLib.readBufferByte((Object)this, byteOffset + 2L);
            byte b4 = thisLib.readBufferByte((Object)this, byteOffset + 3L);
            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                return (b4 & 0xFF) << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
            }
            return (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
        }

        @ExportMessage
        long readBufferLong(ByteOrder byteOrder, long byteOffset, @CachedLibrary(value="this") InteropLibrary thisLib) throws UnsupportedMessageException, InvalidBufferOffsetException {
            byte b1 = thisLib.readBufferByte((Object)this, byteOffset);
            byte b2 = thisLib.readBufferByte((Object)this, byteOffset + 1L);
            byte b3 = thisLib.readBufferByte((Object)this, byteOffset + 2L);
            byte b4 = thisLib.readBufferByte((Object)this, byteOffset + 3L);
            byte b5 = thisLib.readBufferByte((Object)this, byteOffset + 4L);
            byte b6 = thisLib.readBufferByte((Object)this, byteOffset + 5L);
            byte b7 = thisLib.readBufferByte((Object)this, byteOffset + 6L);
            byte b8 = thisLib.readBufferByte((Object)this, byteOffset + 7L);
            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                return ((long)b8 & 0xFFL) << 56 | ((long)b7 & 0xFFL) << 48 | ((long)b6 & 0xFFL) << 40 | ((long)b5 & 0xFFL) << 32 | ((long)b4 & 0xFFL) << 24 | ((long)b3 & 0xFFL) << 16 | ((long)b2 & 0xFFL) << 8 | (long)b1 & 0xFFL;
            }
            return ((long)b1 & 0xFFL) << 56 | ((long)b2 & 0xFFL) << 48 | ((long)b3 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b5 & 0xFFL) << 24 | ((long)b6 & 0xFFL) << 16 | ((long)b7 & 0xFFL) << 8 | (long)b8 & 0xFFL;
        }

        @ExportMessage
        float readBufferFloat(ByteOrder byteOrder, long byteOffset, @CachedLibrary(value="this") InteropLibrary thisLib) throws UnsupportedMessageException, InvalidBufferOffsetException {
            return Float.intBitsToFloat(thisLib.readBufferInt((Object)this, byteOrder, byteOffset));
        }

        @ExportMessage
        double readBufferDouble(ByteOrder byteOrder, long byteOffset, @CachedLibrary(value="this") InteropLibrary thisLib) throws UnsupportedMessageException, InvalidBufferOffsetException {
            return Double.longBitsToDouble(thisLib.readBufferLong((Object)this, byteOrder, byteOffset));
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static abstract class CArrayWrapper
    extends PythonNativeWrapper.PythonStructNativeWrapper {
        public CArrayWrapper(Object delegate) {
            super(delegate);
        }

        @ExportMessage
        boolean isPointer() {
            return this.isNative();
        }

        @ExportMessage
        long asPointer() {
            return this.getNativePointer();
        }

        public void free() {
            if (this.isNative()) {
                CArrayWrappers.freeBoundary(this.getNativePointer());
            }
        }
    }
}

