/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotGetAttr;
import com.oracle.graal.python.lib.PyObjectGetAttrONodeGen;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class PyObjectGetAttrO
extends Node {
    public static Object executeUncached(Object receiver, Object name) {
        return PyObjectGetAttrONodeGen.getUncached().execute(null, null, receiver, name);
    }

    public abstract Object execute(Frame var1, Node var2, Object var3, Object var4);

    @Specialization
    static Object getDynamicAttr(Frame frame, Node inliningTarget, Object receiver, Object name, @Cached GetClassNode getClass, @Cached TpSlots.GetCachedTpSlotsNode getSlotsNode, @Cached TpSlotGetAttr.CallSlotGetAttrONode callGetAttrNode, @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode, @Cached(inline=false) TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        TruffleString tsName;
        Object result;
        Object type = getClass.execute(inliningTarget, receiver);
        TpSlots slots = getSlotsNode.execute(inliningTarget, type);
        if (!codePointLengthNode.isAdoptable() && name instanceof TruffleString && (result = PyObjectLookupAttr.readAttributeQuickly(type, slots, receiver, tsName = (TruffleString)name, codePointLengthNode, codePointAtIndexNode)) != null) {
            if (result == PNone.NO_VALUE) {
                throw PRaiseNode.getUncached().raise(PythonBuiltinClassType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, receiver, name);
            }
            return result;
        }
        return callGetAttrNode.execute((VirtualFrame)frame, inliningTarget, slots, receiver, name);
    }
}

