/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.frame;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.nodes.frame.ReadCallerFrameNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class GetCurrentFrameRef
extends Node {
    public abstract PFrame.Reference execute(Frame var1, Node var2);

    @Specialization(guards={"frame != null"})
    static PFrame.Reference doWithFrame(Frame frame) {
        return PArguments.getCurrentFrameInfo(frame);
    }

    @Specialization(guards={"frame == null"})
    PFrame.Reference doWithoutFrame(Frame frame, @Cached(value="getFlag()", uncached="getFlagUncached()", dimensions=1) ConditionProfile[] flag) {
        PFrame.Reference ref = PythonContext.get(this).peekTopFrameInfo(PythonLanguage.get(this));
        if (flag[0] == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            flag[0] = ConditionProfile.create();
            if (ref == null) {
                ref = PArguments.getCurrentFrameInfo(ReadCallerFrameNode.getCurrentFrame(this, FrameInstance.FrameAccess.READ_ONLY));
            }
        }
        if (flag[0].profile(ref == null)) {
            ref = PArguments.getCurrentFrameInfo(ReadCallerFrameNode.getCurrentFrame(this, FrameInstance.FrameAccess.READ_ONLY));
        }
        return ref;
    }

    @Specialization(replaces={"doWithFrame", "doWithoutFrame"})
    PFrame.Reference doGeneric(Frame frame) {
        if (frame == null) {
            PFrame.Reference ref = PythonContext.get(this).peekTopFrameInfo(PythonLanguage.get(this));
            if (ref == null) {
                return PArguments.getCurrentFrameInfo(ReadCallerFrameNode.getCurrentFrame(this, FrameInstance.FrameAccess.READ_ONLY));
            }
            return ref;
        }
        return PArguments.getCurrentFrameInfo(frame);
    }

    @NeverDefault
    static ConditionProfile[] getFlag() {
        return new ConditionProfile[1];
    }

    static ConditionProfile[] getFlagUncached() {
        return PythonUtils.DISABLED;
    }
}

