/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.parserapplications;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.htmlparser.NodeFactory;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.PrototypicalNodeFactory;
import org.htmlparser.Tag;
import org.htmlparser.filters.AndFilter;
import org.htmlparser.filters.HasAttributeFilter;
import org.htmlparser.filters.NodeClassFilter;
import org.htmlparser.tags.BaseHrefTag;
import org.htmlparser.tags.FrameTag;
import org.htmlparser.tags.ImageTag;
import org.htmlparser.tags.LinkTag;
import org.htmlparser.tags.MetaTag;
import org.htmlparser.util.EncodingChangeException;
import org.htmlparser.util.NodeIterator;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

public class SiteCapturer {
    protected String mSource = null;
    protected String mTarget = null;
    protected ArrayList mPages = new ArrayList();
    protected HashSet mFinished = new HashSet();
    protected ArrayList mImages = new ArrayList();
    protected HashSet mCopied = new HashSet();
    protected Parser mParser = new Parser();
    protected boolean mCaptureResources;
    protected NodeFilter mFilter;
    protected final int TRANSFER_SIZE = 4096;
    static /* synthetic */ Class class$org$htmlparser$tags$MetaTag;

    public SiteCapturer() {
        PrototypicalNodeFactory factory = new PrototypicalNodeFactory();
        factory.registerTag((Tag)new LocalLinkTag());
        factory.registerTag((Tag)new LocalFrameTag());
        factory.registerTag((Tag)new LocalBaseHrefTag());
        factory.registerTag((Tag)new LocalImageTag());
        this.mParser.setNodeFactory((NodeFactory)factory);
        this.mCaptureResources = true;
        this.mFilter = null;
    }

    public String getSource() {
        return this.mSource;
    }

    public void setSource(String source) {
        if (source.endsWith("/")) {
            source = source.substring(0, source.length() - 1);
        }
        this.mSource = source;
    }

    public String getTarget() {
        return this.mTarget;
    }

    public void setTarget(String target) {
        this.mTarget = target;
    }

    public boolean getCaptureResources() {
        return this.mCaptureResources;
    }

    public void setCaptureResources(boolean capture) {
        this.mCaptureResources = capture;
    }

    public NodeFilter getFilter() {
        return this.mFilter;
    }

    public void setFilter(NodeFilter filter) {
        this.mFilter = filter;
    }

    protected boolean isToBeCaptured(String link) {
        return link.toLowerCase().startsWith(this.getSource().toLowerCase()) && -1 == link.indexOf("?") && -1 == link.indexOf("#");
    }

    protected boolean isHtml(String link) throws ParserException {
        boolean ret = false;
        try {
            URL url = new URL(link);
            URLConnection connection = url.openConnection();
            String type = connection.getContentType();
            ret = type == null ? false : type.startsWith("text/html");
        }
        catch (Exception e) {
            throw new ParserException("URL " + link + " has a problem", (Throwable)e);
        }
        return ret;
    }

    protected String makeLocalLink(String link, String current) {
        String ret = link.equals(this.getSource()) || !this.getSource().endsWith("/") && link.equals(this.getSource() + "/") ? "index.html" : (link.startsWith(this.getSource()) && link.length() > this.getSource().length() ? link.substring(this.getSource().length() + 1) : link);
        if (null != current && link.startsWith(this.getSource()) && current.length() > this.getSource().length()) {
            int j;
            current = current.substring(this.getSource().length() + 1);
            int i = 0;
            while (-1 != (j = current.indexOf(47, i))) {
                ret = "../" + ret;
                i = j + 1;
            }
        }
        return ret;
    }

    protected String decode(String raw) {
        int index;
        StringBuffer ret = new StringBuffer(raw.length());
        int length = raw.length();
        int start = 0;
        while (-1 != (index = raw.indexOf(37, start))) {
            ret.append(raw.substring(start, index));
            if (index + 2 < length) {
                try {
                    int value = Integer.parseInt(raw.substring(index + 1, index + 3), 16);
                    ret.append((char)value);
                    start = index + 3;
                }
                catch (NumberFormatException nfe) {
                    ret.append('%');
                    start = index + 1;
                }
                continue;
            }
            ret.append('%');
            start = index + 1;
        }
        ret.append(raw.substring(start));
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy() {
        String link = (String)this.mImages.remove(0);
        this.mCopied.add(link);
        if (this.getCaptureResources()) {
            String raw = this.makeLocalLink(link, "");
            String name = this.decode(raw);
            File file = new File(this.getTarget(), name);
            System.out.println("copying " + link + " to " + file.getAbsolutePath());
            File dir = file.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            try {
                URL source = new URL(link);
                byte[] data = new byte[4096];
                try {
                    InputStream in = source.openStream();
                    try {
                        FileOutputStream out = new FileOutputStream(file);
                        try {
                            int read;
                            while (-1 != (read = in.read(data, 0, data.length))) {
                                out.write(data, 0, read);
                            }
                        }
                        finally {
                            out.close();
                        }
                    }
                    catch (FileNotFoundException fnfe) {
                        fnfe.printStackTrace();
                    }
                    finally {
                        in.close();
                    }
                }
                catch (FileNotFoundException fnfe) {
                    System.err.println("broken link " + fnfe.getMessage() + " ignored");
                }
            }
            catch (MalformedURLException murle) {
                murle.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    protected void process(NodeFilter filter) throws ParserException {
        String url = (String)this.mPages.remove(0);
        System.out.println("processing " + url);
        this.mFinished.add(url);
        try {
            File file;
            File dir;
            NodeList robots;
            NodeList list;
            int bookmark = this.mPages.size();
            this.mParser.setURL(url);
            try {
                list = new NodeList();
                NodeIterator e = this.mParser.elements();
                while (e.hasMoreNodes()) {
                    list.add(e.nextNode());
                }
            }
            catch (EncodingChangeException ece) {
                this.mParser.reset();
                list = new NodeList();
                NodeIterator e = this.mParser.elements();
                while (e.hasMoreNodes()) {
                    list.add(e.nextNode());
                }
            }
            if (0 != (robots = list.extractAllNodesThatMatch((NodeFilter)new AndFilter((NodeFilter)new NodeClassFilter(class$org$htmlparser$tags$MetaTag == null ? (class$org$htmlparser$tags$MetaTag = SiteCapturer.class$("org.htmlparser.tags.MetaTag")) : class$org$htmlparser$tags$MetaTag), (NodeFilter)new HasAttributeFilter("name", "robots")), true)).size()) {
                MetaTag robot = (MetaTag)robots.elementAt(0);
                String content = robot.getAttribute("content").toLowerCase();
                if (-1 != content.indexOf("none") || -1 != content.indexOf("nofollow")) {
                    for (int i = bookmark; i < this.mPages.size(); ++i) {
                        this.mPages.remove(i);
                    }
                }
                if (-1 != content.indexOf("none") || -1 != content.indexOf("noindex")) {
                    return;
                }
            }
            if (null != filter) {
                list.keepAllNodesThatMatch(filter, true);
            }
            if (!(dir = (file = new File(this.getTarget(), this.makeLocalLink(url, ""))).getParentFile()).exists()) {
                dir.mkdirs();
            } else if (!dir.isDirectory()) {
                if (!(dir = new File(dir.getParentFile(), dir.getName() + ".content")).exists()) {
                    dir.mkdirs();
                }
                file = new File(dir, file.getName());
            }
            try {
                PrintWriter out = new PrintWriter(new FileOutputStream(file));
                for (int i = 0; i < list.size(); ++i) {
                    out.print(list.elementAt(i).toHtml());
                }
                out.close();
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
        }
        catch (ParserException pe) {
            String message = pe.getMessage();
            if (null != message && message.endsWith("does not contain text")) {
                if (!this.mCopied.contains(url) && !this.mImages.contains(url)) {
                    this.mImages.add(url);
                }
                this.mFinished.remove(url);
            }
            throw pe;
        }
    }

    public void capture() {
        this.mPages.clear();
        this.mPages.add(this.getSource());
        while (0 != this.mPages.size()) {
            try {
                this.process(this.getFilter());
                while (0 != this.mImages.size()) {
                    this.copy();
                }
            }
            catch (ParserException pe) {
                Throwable throwable = pe.getThrowable();
                if (null != throwable) {
                    if ((throwable = throwable.getCause()) instanceof FileNotFoundException) {
                        System.err.println("broken link " + ((FileNotFoundException)throwable).getMessage() + " ignored");
                        continue;
                    }
                    pe.printStackTrace();
                    continue;
                }
                pe.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws MalformedURLException, IOException {
        String url;
        SiteCapturer worker = new SiteCapturer();
        if (0 >= args.length) {
            url = (String)JOptionPane.showInputDialog(null, "Enter the URL to capture:", "Web Site", -1, null, null, "http://htmlparser.sourceforge.net");
            if (null != url) {
                worker.setSource(url);
            } else {
                System.exit(1);
            }
        } else {
            worker.setSource(args[0]);
        }
        if (1 >= args.length) {
            url = worker.getSource();
            URL source = new URL(url);
            String path = new File(new File("." + File.separator), source.getHost() + File.separator).getCanonicalPath();
            File target = new File(path);
            JFileChooser chooser = new JFileChooser(target);
            chooser.setDialogType(1);
            chooser.setFileSelectionMode(1);
            chooser.setSelectedFile(target);
            chooser.setMultiSelectionEnabled(false);
            chooser.setDialogTitle("Target Directory");
            int ret = chooser.showSaveDialog(null);
            if (ret == 0) {
                worker.setTarget(chooser.getSelectedFile().getAbsolutePath());
            } else {
                System.exit(1);
            }
        } else {
            worker.setTarget(args[1]);
        }
        if (2 >= args.length) {
            Boolean capture = (Boolean)JOptionPane.showInputDialog(null, "Should resources be captured:", "Capture Resources", -1, null, new Object[]{Boolean.TRUE, Boolean.FALSE}, Boolean.TRUE);
            if (null != capture) {
                worker.setCaptureResources(capture);
            } else {
                System.exit(1);
            }
        } else {
            worker.setCaptureResources(Boolean.valueOf(args[2]));
        }
        worker.capture();
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class LocalBaseHrefTag
    extends BaseHrefTag {
        LocalBaseHrefTag() {
        }

        public String toHtml() {
            return "";
        }
    }

    class LocalImageTag
    extends ImageTag {
        LocalImageTag() {
        }

        public void doSemanticAction() throws ParserException {
            String image = this.getImageURL();
            if (SiteCapturer.this.isToBeCaptured(image)) {
                if (!SiteCapturer.this.mCopied.contains(image) && !SiteCapturer.this.mImages.contains(image)) {
                    SiteCapturer.this.mImages.add(image);
                }
                if (SiteCapturer.this.getCaptureResources()) {
                    image = SiteCapturer.this.makeLocalLink(image, SiteCapturer.this.mParser.getLexer().getPage().getUrl());
                }
                this.setImageURL(image);
            }
        }
    }

    class LocalFrameTag
    extends FrameTag {
        LocalFrameTag() {
        }

        public void doSemanticAction() throws ParserException {
            String link = this.getFrameLocation();
            if (SiteCapturer.this.isToBeCaptured(link)) {
                boolean html;
                if (SiteCapturer.this.mFinished.contains(link)) {
                    html = true;
                } else if (SiteCapturer.this.mPages.contains(link)) {
                    html = true;
                } else if (SiteCapturer.this.mCopied.contains(link)) {
                    html = false;
                } else if (SiteCapturer.this.mImages.contains(link)) {
                    html = false;
                } else {
                    html = SiteCapturer.this.isHtml(link);
                    if (html) {
                        SiteCapturer.this.mPages.add(link);
                    } else {
                        SiteCapturer.this.mImages.add(link);
                    }
                }
                if (html || !html && SiteCapturer.this.getCaptureResources()) {
                    link = SiteCapturer.this.makeLocalLink(link, SiteCapturer.this.mParser.getLexer().getPage().getUrl());
                }
                this.setFrameLocation(link);
            }
        }
    }

    class LocalLinkTag
    extends LinkTag {
        LocalLinkTag() {
        }

        public void doSemanticAction() throws ParserException {
            String link = this.getLink();
            if (SiteCapturer.this.isToBeCaptured(link)) {
                boolean html;
                if (SiteCapturer.this.mFinished.contains(link)) {
                    html = true;
                } else if (SiteCapturer.this.mPages.contains(link)) {
                    html = true;
                } else if (SiteCapturer.this.mCopied.contains(link)) {
                    html = false;
                } else if (SiteCapturer.this.mImages.contains(link)) {
                    html = false;
                } else {
                    html = SiteCapturer.this.isHtml(link);
                    if (html) {
                        SiteCapturer.this.mPages.add(link);
                    } else {
                        SiteCapturer.this.mImages.add(link);
                    }
                }
                if (html || !html && SiteCapturer.this.getCaptureResources()) {
                    link = SiteCapturer.this.makeLocalLink(link, SiteCapturer.this.mParser.getLexer().getPage().getUrl());
                }
                this.setLink(link);
            }
        }
    }
}

