/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.config.impl.extension;

import java.net.URL;
import java.util.logging.Logger;
import org.jboss.arquillian.config.impl.extension.ClasspathConfigurationPlaceholderResolver;
import org.jboss.arquillian.config.impl.extension.PropertyResolver;

class ClasspathPropertyResolver
implements PropertyResolver {
    private static final Logger logger = Logger.getLogger(ClasspathConfigurationPlaceholderResolver.class.getName());
    private static final String CLASSPATH = "classpath(";

    ClasspathPropertyResolver() {
    }

    public String getValue(String key) {
        if (key.startsWith(CLASSPATH)) {
            String classpathResource;
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            URL resource = contextClassLoader.getResource(classpathResource = key.substring(CLASSPATH.length(), key.length() - 1));
            if (resource == null) {
                logger.warning(String.format("Resource %s is not found on the classspath so the property %s is not replaced.", classpathResource, key));
                return null;
            }
            return resource.toString();
        }
        return null;
    }
}

