/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import javax.annotation.CheckForNull;
import org.kohsuke.github.GHCommentAuthorAssociation;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestReviewCommentReactions;
import org.kohsuke.github.GHReaction;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Reactable;
import org.kohsuke.github.ReactionContent;
import org.kohsuke.github.Requester;
import org.kohsuke.github.internal.EnumUtils;
import org.kohsuke.github.internal.Previews;

public class GHPullRequestReviewComment
extends GHObject
implements Reactable {
    GHPullRequest owner;
    private Long pull_request_review_id = -1L;
    private String body;
    private GHUser user;
    private String path;
    private String html_url;
    private String pull_request_url;
    private int position = -1;
    private int original_position = -1;
    private long in_reply_to_id = -1L;
    private Integer start_line = -1;
    private Integer original_start_line = -1;
    private String start_side;
    private int line = -1;
    private int original_line = -1;
    private String side;
    private String diff_hunk;
    private String commit_id;
    private String original_commit_id;
    private String body_html;
    private String body_text;
    private GHPullRequestReviewCommentReactions reactions;
    private GHCommentAuthorAssociation author_association;

    @Deprecated
    public static GHPullRequestReviewComment draft(String body, String path, int position) {
        GHPullRequestReviewComment result = new GHPullRequestReviewComment();
        result.body = body;
        result.path = path;
        result.position = position;
        return result;
    }

    GHPullRequestReviewComment wrapUp(GHPullRequest owner) {
        this.owner = owner;
        return this;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHPullRequest getParent() {
        return this.owner;
    }

    public String getBody() {
        return this.body;
    }

    public GHUser getUser() throws IOException {
        return this.owner.root().getUser(this.user.getLogin());
    }

    public String getPath() {
        return this.path;
    }

    @CheckForNull
    public int getPosition() {
        return this.position;
    }

    public int getOriginalPosition() {
        return this.original_position;
    }

    public String getDiffHunk() {
        return this.diff_hunk;
    }

    public String getCommitId() {
        return this.commit_id;
    }

    public String getOriginalCommitId() {
        return this.original_commit_id;
    }

    public GHCommentAuthorAssociation getAuthorAssociation() {
        return this.author_association;
    }

    @CheckForNull
    public long getInReplyToId() {
        return this.in_reply_to_id;
    }

    @Override
    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.html_url);
    }

    protected String getApiRoute() {
        return this.getApiRoute(false);
    }

    protected String getApiRoute(boolean includePullNumber) {
        return "/repos/" + this.owner.getRepository().getFullName() + "/pulls" + (includePullNumber ? "/" + this.owner.getNumber() : "") + "/comments/" + this.getId();
    }

    public int getStartLine() {
        return this.start_line != null ? this.start_line : -1;
    }

    public int getOriginalStartLine() {
        return this.original_start_line != null ? this.original_start_line : -1;
    }

    public Side getStartSide() {
        return Side.from(this.start_side);
    }

    public int getLine() {
        return this.line;
    }

    public int getOriginalLine() {
        return this.original_line;
    }

    public Side getSide() {
        return Side.from(this.side);
    }

    public Long getPullRequestReviewId() {
        return this.pull_request_review_id != null ? this.pull_request_review_id : -1L;
    }

    public URL getPullRequestUrl() {
        return GitHubClient.parseURL(this.pull_request_url);
    }

    public String getBodyHtml() {
        return this.body_html;
    }

    public String getBodyText() {
        return this.body_text;
    }

    public GHPullRequestReviewCommentReactions getReactions() {
        return this.reactions;
    }

    public void update(String body) throws IOException {
        ((Requester)((Requester)((Requester)this.owner.root().createRequest().method("PATCH")).with("body", body)).withUrlPath(this.getApiRoute(), new String[0])).fetchInto(this);
        this.body = body;
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.owner.root().createRequest().method("DELETE")).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    public GHPullRequestReviewComment reply(String body) throws IOException {
        return ((Requester)((Requester)((Requester)this.owner.root().createRequest().method("POST")).with("body", body)).withUrlPath(this.getApiRoute(true) + "/replies", new String[0])).fetch(GHPullRequestReviewComment.class).wrapUp(this.owner);
    }

    @Override
    @Preview(value={Previews.SQUIRREL_GIRL})
    public GHReaction createReaction(ReactionContent content) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)this.owner.root().createRequest().method("POST")).withPreview(Previews.SQUIRREL_GIRL)).with("content", content.getContent())).withUrlPath(this.getApiRoute() + "/reactions", new String[0])).fetch(GHReaction.class);
    }

    @Override
    public void deleteReaction(GHReaction reaction) throws IOException {
        ((Requester)((Requester)this.owner.root().createRequest().method("DELETE")).withUrlPath(this.getApiRoute(), "reactions", String.valueOf(reaction.getId()))).send();
    }

    @Override
    @Preview(value={Previews.SQUIRREL_GIRL})
    public PagedIterable<GHReaction> listReactions() {
        return ((Requester)((Requester)this.owner.root().createRequest().withPreview(Previews.SQUIRREL_GIRL)).withUrlPath(this.getApiRoute() + "/reactions", new String[0])).toIterable(GHReaction[].class, item -> this.owner.root());
    }

    public static enum Side {
        RIGHT,
        LEFT,
        UNKNOWN;


        public static Side from(String value) {
            return EnumUtils.getEnumOrDefault(Side.class, value, UNKNOWN);
        }
    }
}

