/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.connection;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.spark.sql.connector.config.MongoConfig;
import com.mongodb.spark.sql.connector.connection.MongoClientFactory;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class DefaultMongoClientFactory
implements MongoClientFactory {
    private final MongoConfig config;

    public DefaultMongoClientFactory(MongoConfig config) {
        this.config = config;
    }

    @Override
    public MongoClient create() {
        return MongoClients.create((ConnectionString)this.config.getConnectionString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMongoClientFactory that = (DefaultMongoClientFactory)o;
        return Objects.equals(this.config.getConnectionString(), that.config.getConnectionString());
    }

    public int hashCode() {
        return Objects.hash(this.config.getConnectionString());
    }
}

