/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.connection;

import com.mongodb.client.MongoClient;
import com.mongodb.spark.sql.connector.connection.MongoClientCache;
import com.mongodb.spark.sql.connector.connection.MongoClientFactory;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class LazyMongoClientCache {
    private static final MongoClientCache CLIENT_CACHE;
    private static final String SYSTEM_MONGO_CACHE_KEEP_ALIVE_MS_PROPERTY = "spark.mongodb.keep_alive_ms";

    public static MongoClient getMongoClient(MongoClientFactory mongoClientFactory) {
        return CLIENT_CACHE.acquire(mongoClientFactory);
    }

    private LazyMongoClientCache() {
    }

    static {
        int keepAliveMS = 5000;
        try {
            keepAliveMS = Integer.parseInt(System.getProperty(SYSTEM_MONGO_CACHE_KEEP_ALIVE_MS_PROPERTY, "5000"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        CLIENT_CACHE = new MongoClientCache(keepAliveMS);
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
    }

    private static class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            CLIENT_CACHE.shutdown();
        }
    }
}

