/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.connection;

import com.mongodb.ClientSessionOptions;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.ListDatabasesIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.spark.sql.connector.annotations.ThreadSafe;
import com.mongodb.spark.sql.connector.assertions.Assertions;
import com.mongodb.spark.sql.connector.connection.MongoClientFactory;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.VisibleForTesting;

@ThreadSafe
final class MongoClientCache {
    private final HashMap<MongoClientFactory, CachedMongoClient> cache = new HashMap();
    private final long keepAliveNanos;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private boolean isAvailable;
    static final int INITIAL_CLEANUP_DELAY_MS = 1000;
    static final int CLEANUP_DELAY_MS = 200;

    MongoClientCache(long keepAliveMS) {
        this(keepAliveMS, 1000L, 200L);
    }

    @VisibleForTesting
    MongoClientCache(long keepAliveMS, long initialCleanUpDelayMS, long cleanUpDelayMS) {
        this.keepAliveNanos = TimeUnit.NANOSECONDS.convert(keepAliveMS, TimeUnit.MILLISECONDS);
        this.scheduler.scheduleWithFixedDelay(this::checkClientCache, initialCleanUpDelayMS, cleanUpDelayMS, TimeUnit.MILLISECONDS);
        this.isAvailable = true;
    }

    synchronized MongoClient acquire(MongoClientFactory mongoClientFactory) {
        this.assertIsAvailable();
        return this.cache.computeIfAbsent(mongoClientFactory, factory -> new CachedMongoClient(this, factory.create(), this.keepAliveNanos)).acquire();
    }

    synchronized void shutdown() {
        if (this.isAvailable) {
            this.scheduler.shutdownNow();
            this.cache.values().forEach(rec$ -> ((CachedMongoClient)rec$).shutdownClose());
            this.cache.clear();
            this.isAvailable = false;
        }
    }

    private synchronized void checkClientCache() {
        long currentNanos = System.nanoTime();
        this.cache.entrySet().removeIf(e -> ((CachedMongoClient)e.getValue()).shouldBeRemoved(currentNanos));
    }

    private void assertIsAvailable() {
        Assertions.ensureState(() -> this.isAvailable, () -> "The MongoClientCache has been shutdown and is no longer available");
    }

    private static final class CachedMongoClient
    implements MongoClient {
        private final MongoClientCache cache;
        private final MongoClient wrapped;
        private final long keepAliveNanos;
        private long releasedNanos;
        private int referenceCount;

        private CachedMongoClient(MongoClientCache cache, MongoClient wrapped, long keepAliveNanos) {
            this.cache = cache;
            this.wrapped = wrapped;
            this.keepAliveNanos = keepAliveNanos;
            this.releasedNanos = System.nanoTime();
            this.referenceCount = 0;
        }

        private CachedMongoClient acquire() {
            ++this.referenceCount;
            return this;
        }

        private void shutdownClose() {
            this.referenceCount = 0;
            this.wrapped.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            MongoClientCache mongoClientCache = this.cache;
            synchronized (mongoClientCache) {
                this.cache.assertIsAvailable();
                Assertions.ensureState(() -> this.referenceCount > 0, () -> "MongoClient reference count cannot be below zero");
                this.releasedNanos = System.nanoTime();
                --this.referenceCount;
            }
        }

        public MongoDatabase getDatabase(String databaseName) {
            return this.wrapped.getDatabase(databaseName);
        }

        public ClientSession startSession() {
            return this.wrapped.startSession();
        }

        public ClientSession startSession(ClientSessionOptions options) {
            return this.wrapped.startSession(options);
        }

        public MongoIterable<String> listDatabaseNames() {
            return this.wrapped.listDatabaseNames();
        }

        public MongoIterable<String> listDatabaseNames(ClientSession clientSession) {
            return this.wrapped.listDatabaseNames(clientSession);
        }

        public ListDatabasesIterable<Document> listDatabases() {
            return this.wrapped.listDatabases();
        }

        public ListDatabasesIterable<Document> listDatabases(ClientSession clientSession) {
            return this.wrapped.listDatabases(clientSession);
        }

        public <TResult> ListDatabasesIterable<TResult> listDatabases(Class<TResult> tResultClass) {
            return this.wrapped.listDatabases(tResultClass);
        }

        public <TResult> ListDatabasesIterable<TResult> listDatabases(ClientSession clientSession, Class<TResult> tResultClass) {
            return this.wrapped.listDatabases(clientSession, tResultClass);
        }

        public ChangeStreamIterable<Document> watch() {
            return this.wrapped.watch();
        }

        public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> tResultClass) {
            return this.wrapped.watch(tResultClass);
        }

        public ChangeStreamIterable<Document> watch(List<? extends Bson> pipeline) {
            return this.wrapped.watch(pipeline);
        }

        public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> pipeline, Class<TResult> tResultClass) {
            return this.wrapped.watch(pipeline, tResultClass);
        }

        public ChangeStreamIterable<Document> watch(ClientSession clientSession) {
            return this.wrapped.watch(clientSession);
        }

        public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, Class<TResult> tResultClass) {
            return this.wrapped.watch(clientSession, tResultClass);
        }

        public ChangeStreamIterable<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
            return this.wrapped.watch(clientSession, pipeline);
        }

        public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> tResultClass) {
            return this.wrapped.watch(clientSession, pipeline, tResultClass);
        }

        public ClusterDescription getClusterDescription() {
            return this.wrapped.getClusterDescription();
        }

        private boolean shouldBeRemoved(long currentNanos) {
            if (this.referenceCount == 0 && currentNanos - this.releasedNanos > this.keepAliveNanos) {
                try {
                    this.wrapped.close();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }
    }
}

