/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read;

import com.mongodb.spark.sql.connector.read.ResumeTokenPartitionOffset;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.spark.sql.connector.read.InputPartition;
import org.bson.BsonDocument;

public class MongoInputPartition
implements InputPartition {
    private static final long serialVersionUID = 1L;
    private final int partitionId;
    private final List<BsonDocument> pipeline;
    private final List<String> preferredLocations;
    private final ResumeTokenPartitionOffset resumeTokenPartitionOffset;

    public MongoInputPartition(int partitionId, List<BsonDocument> pipeline) {
        this(partitionId, pipeline, Collections.emptyList());
    }

    public MongoInputPartition(int partitionId, List<BsonDocument> pipeline, ResumeTokenPartitionOffset resumeTokenPartitionOffset) {
        this(partitionId, pipeline, Collections.emptyList(), resumeTokenPartitionOffset);
    }

    public MongoInputPartition(int partitionId, List<BsonDocument> pipeline, List<String> preferredLocations) {
        this(partitionId, pipeline, preferredLocations, ResumeTokenPartitionOffset.INITIAL_RESUME_TOKEN_PARTITION_OFFSET);
    }

    MongoInputPartition(int partitionId, List<BsonDocument> pipeline, List<String> preferredLocations, ResumeTokenPartitionOffset resumeTokenPartitionOffset) {
        this.partitionId = partitionId;
        this.pipeline = pipeline;
        this.preferredLocations = preferredLocations;
        this.resumeTokenPartitionOffset = resumeTokenPartitionOffset;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public ResumeTokenPartitionOffset getResumeTokenPartitionOffset() {
        return this.resumeTokenPartitionOffset;
    }

    public List<BsonDocument> getPipeline() {
        return this.pipeline;
    }

    public String[] preferredLocations() {
        return this.preferredLocations.toArray(new String[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoInputPartition that = (MongoInputPartition)o;
        return this.partitionId == that.partitionId && Objects.equals(this.pipeline, that.pipeline) && Objects.equals(this.preferredLocations, that.preferredLocations);
    }

    public int hashCode() {
        return Objects.hash(this.partitionId, this.pipeline, this.preferredLocations);
    }

    public String toString() {
        return "MongoInputPartition{partitionId=" + this.partitionId + ", pipeline=" + this.pipeline.stream().map(BsonDocument::toJson).collect(Collectors.joining(",", "[", "]")) + ", preferredLocations=" + this.preferredLocations + ", resumeTokenPartitionOffset=" + this.resumeTokenPartitionOffset + ", preferredLocations=" + this.preferredLocations + '}';
    }
}

