/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCursor;
import com.mongodb.spark.sql.connector.assertions.Assertions;
import com.mongodb.spark.sql.connector.config.ReadConfig;
import com.mongodb.spark.sql.connector.read.MongoInputPartition;
import com.mongodb.spark.sql.connector.schema.BsonDocumentToRowConverter;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.bson.BsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoPartitionReader
implements PartitionReader<InternalRow> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoPartitionReader.class);
    private final MongoInputPartition partition;
    private final BsonDocumentToRowConverter bsonDocumentToRowConverter;
    private final ReadConfig readConfig;
    private boolean closed = false;
    private MongoClient mongoClient;
    private MongoCursor<BsonDocument> mongoCursor;
    private InternalRow currentRow;

    public MongoPartitionReader(MongoInputPartition partition, BsonDocumentToRowConverter bsonDocumentToRowConverter, ReadConfig readConfig) {
        this.partition = partition;
        this.bsonDocumentToRowConverter = bsonDocumentToRowConverter;
        this.readConfig = readConfig;
        LOGGER.debug("Creating partition reader for: PartitionId: {} with Schema: {}", (Object)partition.getPartitionId(), (Object)bsonDocumentToRowConverter.getSchema());
    }

    public boolean next() {
        Assertions.ensureState(() -> !this.closed, () -> "Cannot call next() on a closed PartitionReader.");
        boolean hasNext = this.getCursor().hasNext();
        if (hasNext) {
            this.currentRow = this.bsonDocumentToRowConverter.toInternalRow((BsonDocument)this.getCursor().next());
        }
        return hasNext;
    }

    public InternalRow get() {
        Assertions.ensureState(() -> !this.closed, () -> "Cannot call get() on a closed PartitionReader.");
        return this.currentRow;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.releaseCursor();
        }
    }

    private MongoCursor<BsonDocument> getCursor() {
        if (this.mongoCursor == null) {
            LOGGER.debug("Opened cursor for partitionId: {}", (Object)this.partition.getPartitionId());
            this.mongoClient = this.readConfig.getMongoClient();
            this.mongoCursor = this.mongoClient.getDatabase(this.readConfig.getDatabaseName()).getCollection(this.readConfig.getCollectionName(), BsonDocument.class).aggregate(this.partition.getPipeline()).allowDiskUse(Boolean.valueOf(this.readConfig.getAggregationAllowDiskUse())).cursor();
        }
        return this.mongoCursor;
    }

    private void releaseCursor() {
        if (this.mongoCursor != null) {
            LOGGER.debug("Closing cursor for partitionId: {}", (Object)this.partition.getPartitionId());
            try {
                this.mongoCursor.close();
            }
            finally {
                this.mongoCursor = null;
                try {
                    this.mongoClient.close();
                }
                finally {
                    this.mongoClient = null;
                }
            }
        }
    }
}

