/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read.partitioner;

import com.mongodb.spark.sql.connector.config.ReadConfig;
import com.mongodb.spark.sql.connector.exceptions.ConfigException;
import com.mongodb.spark.sql.connector.read.MongoInputPartition;
import com.mongodb.spark.sql.connector.read.partitioner.Partitioner;
import com.mongodb.spark.sql.connector.read.partitioner.PartitionerHelper;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
abstract class FieldPartitioner
implements Partitioner {
    public static final String ID_FIELD = "_id";
    public static final String PARTITION_FIELD_DEFAULT = "_id";
    public static final String PARTITION_FIELD_CONFIG = "partition.field";

    FieldPartitioner() {
    }

    String getPartitionField(ReadConfig readConfig) {
        return readConfig.getPartitionerOptions().getOrDefault(PARTITION_FIELD_CONFIG, "_id");
    }

    List<MongoInputPartition> createMongoInputPartitions(String partitionField, List<BsonDocument> upperBounds, ReadConfig readConfig) {
        HashSet<BsonDocument> upperBoundSet = new HashSet<BsonDocument>(upperBounds);
        if (upperBounds.size() != upperBoundSet.size()) {
            throw new ConfigException(String.format("Invalid partitioner configuration. The partitions generated contain duplicates: `%s`", upperBounds.stream().map(BsonDocument::toJson).collect(Collectors.joining(",", "[", "]"))));
        }
        List<String> preferredLocations = PartitionerHelper.getPreferredLocations(readConfig);
        return IntStream.range(0, upperBounds.size() + 1).mapToObj(i -> {
            BsonDocument previous = i > 0 ? (BsonDocument)upperBounds.get(i - 1) : null;
            BsonDocument current = i >= upperBounds.size() ? null : (BsonDocument)upperBounds.get(i);
            BsonDocument matchFilter = new BsonDocument();
            if (previous != null) {
                matchFilter.put(partitionField, (BsonValue)new BsonDocument("$gte", previous.get((Object)partitionField)));
            }
            if (current != null) {
                matchFilter.put(partitionField, (BsonValue)matchFilter.getDocument((Object)partitionField, new BsonDocument()).append("$lt", current.get((Object)partitionField)));
            }
            return new MongoInputPartition(i, PartitionerHelper.createPartitionPipeline(matchFilter, readConfig.getAggregationPipeline()), preferredLocations);
        }).collect(Collectors.toList());
    }
}

