/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read.partitioner;

import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import com.mongodb.spark.sql.connector.config.ReadConfig;
import com.mongodb.spark.sql.connector.read.MongoInputPartition;
import com.mongodb.spark.sql.connector.read.partitioner.FieldPartitioner;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
abstract class PaginatePartitioner
extends FieldPartitioner {
    PaginatePartitioner() {
    }

    List<MongoInputPartition> createMongoInputPartitions(long count, int numDocumentsPerPartition, ReadConfig readConfig) {
        String partitionField = this.getPartitionField(readConfig);
        return this.createMongoInputPartitions(partitionField, this.createUpperBounds(partitionField, count, numDocumentsPerPartition, readConfig), readConfig);
    }

    private List<BsonDocument> createUpperBounds(String partitionField, long count, int numDocumentsPerPartition, ReadConfig readConfig) {
        int numberOfPartitions = (int)Math.ceil((double)count / (double)numDocumentsPerPartition);
        ArrayList<BsonDocument> upperBounds = new ArrayList<BsonDocument>();
        for (int i = 0; i < numberOfPartitions; ++i) {
            Bson projection = partitionField.equals("_id") ? Projections.include((String[])new String[]{partitionField}) : Projections.fields((Bson[])new Bson[]{Projections.include((String[])new String[]{partitionField}), Projections.excludeId()});
            ArrayList<BsonDocument> aggregationPipeline = new ArrayList<BsonDocument>(readConfig.getAggregationPipeline());
            aggregationPipeline.add((BsonDocument)Aggregates.project((Bson)projection));
            aggregationPipeline.add((BsonDocument)Aggregates.sort((Bson)Sorts.ascending((String[])new String[]{partitionField})));
            BsonDocument boundary = (BsonDocument)readConfig.withCollection(coll -> {
                ArrayList<Bson> boundaryPipeline = new ArrayList<Bson>();
                if (!upperBounds.isEmpty()) {
                    BsonDocument previous = (BsonDocument)upperBounds.get(upperBounds.size() - 1);
                    BsonDocument matchFilter = new BsonDocument();
                    if (previous.containsKey((Object)partitionField)) {
                        matchFilter.put(partitionField, (BsonValue)new BsonDocument("$gte", previous.get((Object)partitionField)));
                    }
                    boundaryPipeline.add(Aggregates.match((Bson)matchFilter));
                }
                boundaryPipeline.addAll(aggregationPipeline);
                boundaryPipeline.add(Aggregates.skip((int)numDocumentsPerPartition));
                boundaryPipeline.add(Aggregates.limit((int)1));
                return (BsonDocument)coll.aggregate(boundaryPipeline).allowDiskUse(Boolean.valueOf(readConfig.getAggregationAllowDiskUse())).first();
            });
            if (boundary == null) break;
            upperBounds.add(boundary);
        }
        return upperBounds;
    }
}

