/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read.partitioner;

import com.mongodb.ServerAddress;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import com.mongodb.spark.sql.connector.assertions.Assertions;
import com.mongodb.spark.sql.connector.config.ReadConfig;
import com.mongodb.spark.sql.connector.exceptions.MongoSparkException;
import com.mongodb.spark.sql.connector.read.MongoInputPartition;
import com.mongodb.spark.sql.connector.read.partitioner.Partitioner;
import com.mongodb.spark.sql.connector.read.partitioner.PartitionerHelper;
import com.mongodb.spark.sql.connector.read.partitioner.SinglePartitionPartitioner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class ShardedPartitioner
implements Partitioner {
    private static final String CONFIG_DATABASE = "config";
    private static final String CONFIG_COLLECTIONS = "collections";
    private static final String CONFIG_CHUNKS = "chunks";
    private static final String CONFIG_SHARDS = "shards";
    private static final String NAMESPACE_FIELD = "ns";
    private static final String UUID_FIELD = "uuid";
    private static final String ID_FIELD = "_id";
    private static final String HOST_FIELD = "host";
    private static final Bson CHUNKS_PROJECTIONS = Projections.include((String[])new String[]{"min", "max", "shard"});
    private static final Bson SHARDS_PROJECTIONS = Projections.include((String[])new String[]{"_id", "host"});
    private static final Bson SORTS = Sorts.ascending((String[])new String[]{"min"});
    private static final BsonValue BSON_MIN = new BsonMinKey();
    private static final BsonValue BSON_MAX = new BsonMaxKey();

    @Override
    public List<MongoInputPartition> generatePartitions(ReadConfig readConfig) {
        LOGGER.info("Getting shard chunk bounds for '{}'", (Object)readConfig.getNamespace().getFullName());
        BsonDocument configCollectionMetadata = (BsonDocument)readConfig.withClient(client -> (BsonDocument)client.getDatabase(CONFIG_DATABASE).getCollection(CONFIG_COLLECTIONS, BsonDocument.class).find(Filters.eq((String)ID_FIELD, (Object)readConfig.getNamespace().getFullName())).projection(Projections.include((String[])new String[]{ID_FIELD, "timestamp", UUID_FIELD, "dropped", "key"})).first());
        if (configCollectionMetadata == null) {
            LOGGER.warn("Collection '{}' does not appear to be sharded, continuing with a single partition. To split the collections into multiple partitions please use a suitable partitioner.", (Object)readConfig.getNamespace().getFullName());
            return new SinglePartitionPartitioner().generatePartitions(readConfig);
        }
        if (configCollectionMetadata.getBoolean((Object)"dropped", BsonBoolean.FALSE).getValue()) {
            LOGGER.warn("Collection '{}' has been dropped continuing with a single partition.", (Object)readConfig.getNamespace().getFullName());
            return new SinglePartitionPartitioner().generatePartitions(readConfig);
        }
        BsonDocument keyDocument = configCollectionMetadata.getDocument((Object)"key", new BsonDocument());
        if (keyDocument.keySet().size() > 1) {
            throw new MongoSparkException("Invalid partitioner strategy. The Sharded partitioner does not support compound shard keys.");
        }
        if (keyDocument.containsValue((Object)new BsonString("hashed"))) {
            throw new MongoSparkException("Invalid partitioner strategy. The Sharded partitioner does not support hashed shard keys.");
        }
        Bson chunksMatchPredicate = Filters.or((Bson[])new Bson[]{new BsonDocument(NAMESPACE_FIELD, configCollectionMetadata.get((Object)ID_FIELD)), new BsonDocument(UUID_FIELD, configCollectionMetadata.get((Object)UUID_FIELD))});
        List chunks = (List)readConfig.withClient(client -> (ArrayList)client.getDatabase(CONFIG_DATABASE).getCollection(CONFIG_CHUNKS, BsonDocument.class).find(chunksMatchPredicate).projection(CHUNKS_PROJECTIONS).sort(SORTS).into(new ArrayList()));
        List<MongoInputPartition> partitions = this.createMongoInputPartitions(chunks, readConfig);
        if (partitions.isEmpty()) {
            LOGGER.warn("There is no chunk information for '{}' using a single partition", (Object)readConfig.getNamespace().getFullName());
            return new SinglePartitionPartitioner().generatePartitions(readConfig);
        }
        return partitions;
    }

    @NotNull
    private List<MongoInputPartition> createMongoInputPartitions(List<BsonDocument> chunks, ReadConfig readConfig) {
        Map<String, List<String>> shardMap = this.createShardMap(readConfig);
        return IntStream.range(0, chunks.size()).mapToObj(i -> {
            BsonDocument chunkDocument = (BsonDocument)chunks.get(i);
            BsonDocument min = chunkDocument.getDocument((Object)"min");
            BsonDocument max = chunkDocument.getDocument((Object)"max");
            BsonDocument partitionBounds = new BsonDocument();
            Assertions.ensureState(() -> min.keySet().equals(max.keySet()), () -> String.format("Unexpected chunk data information. Differing keys for min / max ranges. %s", chunkDocument.toJson()));
            min.keySet().forEach(shardKey -> {
                BsonDocument shardKeyBoundary = PartitionerHelper.createPartitionBounds((BsonValue)min.getOrDefault(shardKey, (Object)BSON_MIN), max.get(shardKey, BSON_MAX));
                if (!shardKeyBoundary.isEmpty()) {
                    partitionBounds.put(shardKey, (BsonValue)shardKeyBoundary);
                }
            });
            if (partitionBounds.isEmpty()) {
                return null;
            }
            return new MongoInputPartition(i, PartitionerHelper.createPartitionPipeline(partitionBounds, readConfig.getAggregationPipeline()), (List)shardMap.get(chunkDocument.getString((Object)"shard", new BsonString("")).getValue()));
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    private Map<String, List<String>> createShardMap(ReadConfig readConfig) {
        return (Map)readConfig.withClient(client -> ((ArrayList)client.getDatabase(CONFIG_DATABASE).getCollection(CONFIG_SHARDS, BsonDocument.class).find().projection(SHARDS_PROJECTIONS).into(new ArrayList())).stream().collect(Collectors.toMap(s -> s.getString((Object)ID_FIELD).getValue(), s -> this.getHosts(s.getString((Object)HOST_FIELD).getValue()))));
    }

    @VisibleForTesting
    @NotNull
    List<String> getHosts(String hosts) {
        return Arrays.stream(hosts.split(",")).map(String::trim).map(hostAndPort -> {
            String[] splitHostAndPort = hostAndPort.split("/");
            return new ServerAddress(splitHostAndPort[splitHostAndPort.length - 1]).getHost();
        }).distinct().collect(Collectors.toList());
    }
}

