/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.schema;

import com.mongodb.spark.sql.connector.exceptions.DataException;
import com.mongodb.spark.sql.connector.schema.ConverterHelper;
import com.mongodb.spark.sql.connector.schema.RowToInternalRowFunction;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.bson.BsonArray;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonNumber;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.RawBsonDocument;
import org.bson.codecs.EncoderContext;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;
import org.bson.json.JsonWriterSettings;
import org.bson.types.Decimal128;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import scala.collection.JavaConverters$;
import scala.collection.Map;

@NotNull
public final class BsonDocumentToRowConverter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Function<Row, InternalRow> rowToInternalRowFunction;
    private final StructType schema;

    @TestOnly
    public BsonDocumentToRowConverter() {
        this(new StructType());
    }

    public BsonDocumentToRowConverter(StructType schema) {
        this(schema, new RowToInternalRowFunction(schema));
    }

    private BsonDocumentToRowConverter(StructType schema, Function<Row, InternalRow> rowToInternalRowFunction) {
        this.schema = schema;
        this.rowToInternalRowFunction = rowToInternalRowFunction;
    }

    public StructType getSchema() {
        return this.schema;
    }

    @VisibleForTesting
    GenericRowWithSchema toRow(BsonDocument bsonDocument) {
        return this.convertToRow("", this.schema, (BsonValue)bsonDocument, ConverterHelper.DEFAULT_JSON_WRITER_SETTINGS);
    }

    public InternalRow toInternalRow(BsonDocument bsonDocument) {
        return this.rowToInternalRowFunction.apply((Row)this.toRow(bsonDocument));
    }

    @VisibleForTesting
    Object convertBsonValue(String fieldName, DataType dataType, BsonValue bsonValue, JsonWriterSettings jsonWriterSettings) {
        if (bsonValue.isNull()) {
            return null;
        }
        if (dataType instanceof StructType) {
            return this.convertToRow(fieldName, (StructType)dataType, bsonValue, jsonWriterSettings);
        }
        if (dataType instanceof MapType) {
            return this.convertToMap(fieldName, (MapType)dataType, bsonValue, jsonWriterSettings);
        }
        if (dataType instanceof ArrayType) {
            return this.convertToArray(fieldName, (ArrayType)dataType, bsonValue, jsonWriterSettings);
        }
        if (dataType instanceof BinaryType) {
            return this.convertToBinary(fieldName, dataType, bsonValue);
        }
        if (dataType instanceof BooleanType) {
            return this.convertToBoolean(fieldName, dataType, bsonValue);
        }
        if (dataType instanceof DateType) {
            return this.convertToTimestamp(fieldName, dataType, bsonValue, jsonWriterSettings);
        }
        if (dataType instanceof TimestampType) {
            return this.convertToTimestamp(fieldName, dataType, bsonValue, jsonWriterSettings);
        }
        if (dataType instanceof FloatType) {
            return Float.valueOf(this.convertToFloat(fieldName, dataType, bsonValue, jsonWriterSettings));
        }
        if (dataType instanceof IntegerType) {
            return this.convertToInteger(fieldName, dataType, bsonValue, jsonWriterSettings);
        }
        if (dataType instanceof DoubleType) {
            return this.convertToDouble(fieldName, dataType, bsonValue, jsonWriterSettings);
        }
        if (dataType instanceof ShortType) {
            return this.convertToShort(fieldName, dataType, bsonValue, jsonWriterSettings);
        }
        if (dataType instanceof ByteType) {
            return this.convertToByte(fieldName, dataType, bsonValue, jsonWriterSettings);
        }
        if (dataType instanceof LongType) {
            return this.convertToLong(fieldName, dataType, bsonValue, jsonWriterSettings);
        }
        if (dataType instanceof DecimalType) {
            return this.convertToDecimal(fieldName, dataType, bsonValue, jsonWriterSettings);
        }
        if (dataType instanceof StringType) {
            return this.convertToString(bsonValue, jsonWriterSettings);
        }
        if (dataType instanceof NullType) {
            return null;
        }
        throw this.invalidFieldData(fieldName, dataType, bsonValue);
    }

    private GenericRowWithSchema convertToRow(String fieldName, StructType dataType, BsonValue bsonValue, JsonWriterSettings jsonWriterSettings) {
        if (!bsonValue.isDocument()) {
            throw this.invalidFieldData(fieldName, (DataType)dataType, bsonValue);
        }
        BsonDocument bsonDocument = bsonValue.asDocument();
        ArrayList<Object> values = new ArrayList<Object>();
        for (StructField field : dataType.fields()) {
            boolean hasField = bsonDocument.containsKey((Object)field.name());
            String fullFieldPath = this.createFieldPath(fieldName, field.name());
            if (!hasField && !field.nullable()) {
                throw this.missingFieldException(fullFieldPath, bsonDocument, jsonWriterSettings);
            }
            values.add(hasField ? this.convertBsonValue(fullFieldPath, field.dataType(), bsonDocument.get((Object)field.name()), jsonWriterSettings) : null);
        }
        return new GenericRowWithSchema(values.toArray(), dataType);
    }

    private Map<String, ?> convertToMap(String fieldName, MapType dataType, BsonValue bsonValue, JsonWriterSettings jsonWriterSettings) {
        if (!bsonValue.isDocument()) {
            throw this.invalidFieldData(fieldName, (DataType)dataType, bsonValue);
        }
        if (!(dataType.keyType() instanceof StringType)) {
            throw this.invalidFieldData(fieldName, (DataType)dataType, bsonValue, " Map keys must be strings.");
        }
        HashMap map = new HashMap();
        bsonValue.asDocument().forEach((k, v) -> map.put(k, this.convertBsonValue(this.createFieldPath(fieldName, (String)k), dataType.valueType(), (BsonValue)v, jsonWriterSettings)));
        return JavaConverters$.MODULE$.mapAsScalaMap(map);
    }

    private Object[] convertToArray(String fieldName, ArrayType dataType, BsonValue bsonValue, JsonWriterSettings jsonWriterSettings) {
        if (!bsonValue.isArray()) {
            throw this.invalidFieldData(fieldName, (DataType)dataType, bsonValue);
        }
        BsonArray bsonArray = bsonValue.asArray();
        ArrayList<Object> arrayList = new ArrayList<Object>(bsonArray.size());
        for (int i = 0; i < bsonArray.size(); ++i) {
            arrayList.add(this.convertBsonValue(this.createFieldPath(fieldName, String.valueOf(i)), dataType.elementType(), bsonArray.get(i), jsonWriterSettings));
        }
        return arrayList.toArray();
    }

    private byte[] convertToBinary(String fieldName, DataType dataType, BsonValue bsonValue) {
        switch (bsonValue.getBsonType()) {
            case STRING: {
                return bsonValue.asString().getValue().trim().getBytes(StandardCharsets.UTF_8);
            }
            case BINARY: {
                return bsonValue.asBinary().getData();
            }
            case DOCUMENT: {
                return BsonDocumentToRowConverter.documentToByteArray(bsonValue.asDocument());
            }
        }
        throw this.invalidFieldData(fieldName, dataType, bsonValue);
    }

    private boolean convertToBoolean(String fieldName, DataType dataType, BsonValue bsonValue) {
        if (!bsonValue.isBoolean()) {
            throw this.invalidFieldData(fieldName, dataType, bsonValue);
        }
        return bsonValue.asBoolean().getValue();
    }

    private Timestamp convertToTimestamp(String fieldName, DataType dataType, BsonValue bsonValue, JsonWriterSettings jsonWriterSettings) {
        return new Timestamp(this.convertToLong(fieldName, dataType, bsonValue, jsonWriterSettings));
    }

    private float convertToFloat(String fieldName, DataType dataType, BsonValue bsonValue, JsonWriterSettings jsonWriterSettings) {
        return (float)this.convertToBsonNumber(fieldName, dataType, bsonValue, jsonWriterSettings).doubleValue();
    }

    private double convertToDouble(String fieldName, DataType dataType, BsonValue bsonValue, JsonWriterSettings jsonWriterSettings) {
        return this.convertToBsonNumber(fieldName, dataType, bsonValue, jsonWriterSettings).doubleValue();
    }

    private int convertToInteger(String fieldName, DataType dataType, BsonValue bsonValue, JsonWriterSettings jsonWriterSettings) {
        return this.convertToBsonNumber(fieldName, dataType, bsonValue, jsonWriterSettings).intValue();
    }

    private short convertToShort(String fieldName, DataType dataType, BsonValue bsonValue, JsonWriterSettings jsonWriterSettings) {
        return (short)this.convertToBsonNumber(fieldName, dataType, bsonValue, jsonWriterSettings).intValue();
    }

    private long convertToLong(String fieldName, DataType dataType, BsonValue bsonValue, JsonWriterSettings jsonWriterSettings) {
        return this.convertToBsonNumber(fieldName, dataType, bsonValue, jsonWriterSettings).longValue();
    }

    private BigDecimal convertToDecimal(String fieldName, DataType dataType, BsonValue bsonValue, JsonWriterSettings jsonWriterSettings) {
        BsonNumber bsonNumber = this.convertToBsonNumber(fieldName, dataType, bsonValue, jsonWriterSettings);
        switch (bsonNumber.getBsonType()) {
            case DOUBLE: {
                return BigDecimal.valueOf(bsonNumber.doubleValue());
            }
            case INT32: 
            case INT64: {
                return BigDecimal.valueOf(bsonNumber.longValue());
            }
        }
        return bsonNumber.decimal128Value().bigDecimalValue();
    }

    private byte convertToByte(String fieldName, DataType dataType, BsonValue bsonValue, JsonWriterSettings jsonWriterSettings) {
        return (byte)this.convertToBsonNumber(fieldName, dataType, bsonValue, jsonWriterSettings).longValue();
    }

    private String convertToString(BsonValue bsonValue, JsonWriterSettings jsonWriterSettings) {
        switch (bsonValue.getBsonType()) {
            case STRING: {
                return bsonValue.asString().getValue();
            }
            case SYMBOL: {
                return bsonValue.asSymbol().getSymbol();
            }
            case DOCUMENT: {
                return bsonValue.asDocument().toJson(jsonWriterSettings);
            }
        }
        String value = new BsonDocument("v", bsonValue).toJson(jsonWriterSettings);
        value = value.substring(6, value.length() - 1);
        if (value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    private BsonNumber convertToBsonNumber(String fieldName, DataType dataType, BsonValue bsonValue, JsonWriterSettings jsonWriterSettings) {
        switch (bsonValue.getBsonType()) {
            case DATE_TIME: {
                return new BsonInt64(bsonValue.asDateTime().getValue());
            }
            case TIMESTAMP: {
                return new BsonInt64(TimeUnit.SECONDS.toMillis(bsonValue.asTimestamp().getTime()));
            }
            case STRING: {
                try {
                    return new BsonDecimal128(Decimal128.parse((String)this.convertToString(bsonValue, jsonWriterSettings)));
                }
                catch (NumberFormatException e) {
                    throw this.invalidFieldData(fieldName, dataType, bsonValue);
                }
            }
        }
        if (bsonValue instanceof BsonNumber) {
            return (BsonNumber)bsonValue;
        }
        throw this.invalidFieldData(fieldName, dataType, bsonValue);
    }

    private String createFieldPath(String currentLevel, String subLevel) {
        return currentLevel.isEmpty() ? subLevel : String.format("%s.%s", currentLevel, subLevel);
    }

    private DataException invalidFieldData(String fieldName, DataType dataType, BsonValue bsonValue) {
        return this.invalidFieldData(fieldName, dataType, bsonValue, "");
    }

    private DataException invalidFieldData(String fieldName, DataType dataType, BsonValue bsonValue, String extraMessage) {
        return new DataException(String.format("Invalid field: '%s'. The dataType '%s' is invalid for '%s'.%s", fieldName, dataType.typeName(), bsonValue, extraMessage));
    }

    private DataException missingFieldException(String fieldPath, BsonDocument value, JsonWriterSettings jsonWriterSettings) {
        return new DataException(String.format("Missing field '%s' in: '%s'", fieldPath, value.toJson(jsonWriterSettings)));
    }

    @VisibleForTesting
    static byte[] documentToByteArray(BsonDocument document) {
        if (document instanceof RawBsonDocument) {
            RawBsonDocument rawBsonDocument = (RawBsonDocument)document;
            ByteBuffer byteBuffer = rawBsonDocument.getByteBuffer().asNIO();
            int startPosition = byteBuffer.position();
            int length = byteBuffer.limit() - startPosition;
            byte[] byteArray = new byte[length];
            System.arraycopy(byteBuffer.array(), startPosition, byteArray, 0, length);
            return byteArray;
        }
        BasicOutputBuffer buffer = new BasicOutputBuffer();
        try (BsonBinaryWriter writer = new BsonBinaryWriter((BsonOutput)buffer);){
            ConverterHelper.BSON_VALUE_CODEC.encode((BsonWriter)writer, (Object)document, EncoderContext.builder().build());
        }
        return buffer.toByteArray();
    }

    public String toString() {
        return "BsonDocumentToRowConverter{schema=" + this.schema + '}';
    }
}

