/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.blas.impl;

import org.nd4j.linalg.api.blas.Level1;
import org.nd4j.linalg.api.blas.impl.SparseBaseLevel;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.BaseSparseNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.executioner.DefaultOpExecutioner;

public abstract class SparseBaseLevel1
extends SparseBaseLevel
implements Level1 {
    @Override
    public double dot(int n, double alpha, INDArray X, INDArray Y) {
        if (X instanceof BaseSparseNDArray) {
            BaseSparseNDArray sparseX = (BaseSparseNDArray)X;
            DataBuffer pointers = sparseX.getVectorCoordinates();
            switch (X.data().dataType()) {
                case DOUBLE: {
                    DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, X, Y);
                    return this.ddoti(n, X, pointers, Y);
                }
                case FLOAT: {
                    DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, X, Y);
                    return this.sdoti(n, X, pointers, Y);
                }
                case HALF: {
                    DefaultOpExecutioner.validateDataType(DataBuffer.Type.HALF, X, Y);
                    return this.hdoti(n, X, pointers, Y);
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public double dot(int n, DataBuffer dx, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNumber dot(int n, IComplexNumber alpha, IComplexNDArray X, IComplexNDArray Y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double nrm2(INDArray arr) {
        switch (arr.data().dataType()) {
            case DOUBLE: {
                DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, arr);
                return this.dnrm2(arr.length(), arr, 1);
            }
            case FLOAT: {
                DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, arr);
                return this.snrm2(arr.length(), arr, 1);
            }
            case HALF: {
                return this.hnrm2(arr.length(), arr, 1);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNumber nrm2(IComplexNDArray arr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double asum(INDArray arr) {
        switch (arr.data().dataType()) {
            case DOUBLE: {
                DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, arr);
                return this.dasum(arr.length(), arr, 1);
            }
            case FLOAT: {
                DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, arr);
                return this.sasum(arr.length(), arr, 1);
            }
            case HALF: {
                DefaultOpExecutioner.validateDataType(DataBuffer.Type.HALF, arr);
                return this.hasum(arr.length(), arr, 1);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public double asum(int n, DataBuffer x, int offsetX, int incrX) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNumber asum(IComplexNDArray arr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int iamax(INDArray arr) {
        switch (arr.data().dataType()) {
            case DOUBLE: {
                DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, arr);
                return this.idamax(arr.length(), arr, 1);
            }
            case FLOAT: {
                DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, arr);
                return this.isamax(arr.length(), arr, 1);
            }
            case HALF: {
                DefaultOpExecutioner.validateDataType(DataBuffer.Type.HALF, arr);
                return this.ihamax(arr.length(), arr, 1);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int iamax(int n, INDArray arr, int stride) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int iamax(int n, DataBuffer x, int offsetX, int incrX) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int iamax(IComplexNDArray arr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int iamin(INDArray arr) {
        switch (arr.data().dataType()) {
            case DOUBLE: {
                DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, arr);
                return this.idamin(arr.length(), arr, 1);
            }
            case FLOAT: {
                DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, arr);
                return this.isamin(arr.length(), arr, 1);
            }
            case HALF: {
                DefaultOpExecutioner.validateDataType(DataBuffer.Type.HALF, arr);
                return this.ihamin(arr.length(), arr, 1);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int iamin(IComplexNDArray arr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void swap(INDArray x, INDArray y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void swap(IComplexNDArray x, IComplexNDArray y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copy(INDArray x, INDArray y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copy(int n, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copy(IComplexNDArray x, IComplexNDArray y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void axpy(int n, double alpha, INDArray x, INDArray y) {
        BaseSparseNDArray sparseX = (BaseSparseNDArray)x;
        DataBuffer pointers = sparseX.getVectorCoordinates();
        switch (x.data().dataType()) {
            case DOUBLE: {
                DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, x);
                DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, y);
                this.daxpyi(n, alpha, x, pointers, y);
                break;
            }
            case FLOAT: {
                DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, x);
                DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, y);
                this.saxpyi(n, alpha, x, pointers, y);
                break;
            }
            case HALF: {
                DefaultOpExecutioner.validateDataType(DataBuffer.Type.HALF, x);
                DefaultOpExecutioner.validateDataType(DataBuffer.Type.HALF, y);
                this.haxpyi(n, alpha, x, pointers, y);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void axpy(int n, double alpha, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void axpy(int n, IComplexNumber alpha, IComplexNDArray x, IComplexNDArray y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rotg(INDArray a, INDArray b, INDArray c, INDArray s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rot(int N, INDArray X, INDArray Y, double c, double s) {
        if (X instanceof BaseSparseNDArray) {
            BaseSparseNDArray sparseX = (BaseSparseNDArray)X;
            switch (X.data().dataType()) {
                case DOUBLE: {
                    this.droti(N, X, sparseX.getVectorCoordinates(), Y, c, s);
                    break;
                }
                case FLOAT: {
                    this.sroti(N, X, sparseX.getVectorCoordinates(), Y, c, s);
                    break;
                }
                case HALF: {
                    this.hroti(N, X, sparseX.getVectorCoordinates(), Y, c, s);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void rot(int N, IComplexNDArray X, IComplexNDArray Y, IComplexNumber c, IComplexNumber s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rotmg(INDArray d1, INDArray d2, INDArray b1, double b2, INDArray P) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rotmg(IComplexNDArray d1, IComplexNDArray d2, IComplexNDArray b1, IComplexNumber b2, IComplexNDArray P) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void scal(int N, double alpha, INDArray X) {
        switch (X.data().dataType()) {
            case DOUBLE: {
                this.dscal(N, alpha, X, 1);
                break;
            }
            case FLOAT: {
                this.sscal(N, alpha, X, 1);
                break;
            }
            case HALF: {
                this.hscal(N, alpha, X, 1);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void scal(int N, IComplexNumber alpha, IComplexNDArray X) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsDataBufferL1Ops() {
        return false;
    }

    protected abstract double ddoti(int var1, INDArray var2, DataBuffer var3, INDArray var4);

    protected abstract double sdoti(int var1, INDArray var2, DataBuffer var3, INDArray var4);

    protected abstract double hdoti(int var1, INDArray var2, DataBuffer var3, INDArray var4);

    protected abstract double snrm2(int var1, INDArray var2, int var3);

    protected abstract double dnrm2(int var1, INDArray var2, int var3);

    protected abstract double hnrm2(int var1, INDArray var2, int var3);

    protected abstract double dasum(int var1, INDArray var2, int var3);

    protected abstract double sasum(int var1, INDArray var2, int var3);

    protected abstract double hasum(int var1, INDArray var2, int var3);

    protected abstract int isamax(int var1, INDArray var2, int var3);

    protected abstract int idamax(int var1, INDArray var2, int var3);

    protected abstract int ihamax(int var1, INDArray var2, int var3);

    protected abstract int isamin(int var1, INDArray var2, int var3);

    protected abstract int idamin(int var1, INDArray var2, int var3);

    protected abstract int ihamin(int var1, INDArray var2, int var3);

    protected abstract void daxpyi(int var1, double var2, INDArray var4, DataBuffer var5, INDArray var6);

    protected abstract void saxpyi(int var1, double var2, INDArray var4, DataBuffer var5, INDArray var6);

    protected abstract void haxpyi(int var1, double var2, INDArray var4, DataBuffer var5, INDArray var6);

    protected abstract void droti(int var1, INDArray var2, DataBuffer var3, INDArray var4, double var5, double var7);

    protected abstract void sroti(int var1, INDArray var2, DataBuffer var3, INDArray var4, double var5, double var7);

    protected abstract void hroti(int var1, INDArray var2, DataBuffer var3, INDArray var4, double var5, double var7);

    protected abstract void dscal(int var1, double var2, INDArray var4, int var5);

    protected abstract void sscal(int var1, double var2, INDArray var4, int var5);

    protected abstract void hscal(int var1, double var2, INDArray var4, int var5);
}

