/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.LinAlgExceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTransformOp
extends BaseOp
implements TransformOp {
    private static final Logger log = LoggerFactory.getLogger(BaseTransformOp.class);

    public BaseTransformOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2) {
        this(sameDiff, i_v1, i_v2, false);
    }

    public BaseTransformOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, boolean inPlace) {
        super(sameDiff, inPlace, new Object[]{i_v2});
        if (i_v1 != null && i_v2 != null) {
            this.f().validateDifferentialFunctionsameDiff(i_v1);
            this.f().validateDifferentialFunctionsameDiff(i_v2);
            this.sameDiff = sameDiff;
            this.inPlace = inPlace;
            this.xVertexId = i_v1.getVarName();
            this.yVertexId = i_v2.getVarName();
            sameDiff.addArgsFor(new SDVariable[]{i_v1, i_v2}, (DifferentialFunction)this);
            if (Shape.isPlaceholderShape(i_v1.getShape())) {
                sameDiff.addPropertyToResolve(this, i_v1.getVarName());
            }
            if (Shape.isPlaceholderShape(i_v2.getShape())) {
                sameDiff.addPropertyToResolve(this, i_v2.getVarName());
            }
            if (i_v1.getShape() != null) {
                this.n = ArrayUtil.prod((int[])i_v1.getShape());
            }
        } else {
            throw new IllegalArgumentException("Input not null variables.");
        }
    }

    public BaseTransformOp(SameDiff sameDiff) {
        this.sameDiff = sameDiff;
    }

    public BaseTransformOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, Object[] extraArgs) {
        super(sameDiff, extraArgs);
        if (i_v1 != null && i_v2 != null) {
            this.f().validateDifferentialFunctionsameDiff(i_v1);
            this.f().validateDifferentialFunctionsameDiff(i_v2);
            this.sameDiff = sameDiff;
            this.xVertexId = i_v1.getVarName();
            this.yVertexId = i_v2.getVarName();
            sameDiff.addArgsFor(new SDVariable[]{i_v1, i_v2}, (DifferentialFunction)this);
            if (i_v1.getShape() != null) {
                this.n = ArrayUtil.prod((int[])i_v1.getShape());
            }
            if (Shape.isPlaceholderShape(i_v1.getShape())) {
                sameDiff.addPropertyToResolve(this, i_v1.getVarName());
            }
            if (Shape.isPlaceholderShape(i_v2.getShape())) {
                sameDiff.addPropertyToResolve(this, i_v2.getVarName());
            }
        } else {
            throw new IllegalArgumentException("Input not null variables.");
        }
    }

    public BaseTransformOp(SameDiff sameDiff, SDVariable i_v, boolean inPlace) {
        this(sameDiff, i_v, i_v.getShape(), inPlace, null);
    }

    public BaseTransformOp(SameDiff sameDiff, SDVariable i_v, int[] shape, boolean inPlace, Object[] extraArgs) {
        super(sameDiff, inPlace, extraArgs);
        if (i_v != null) {
            this.f().validateDifferentialFunctionsameDiff(i_v);
            this.xVertexId = i_v.getVarName();
            sameDiff.addArgsFor(new SDVariable[]{i_v}, (DifferentialFunction)this);
            if (i_v.getShape() != null) {
                this.n = ArrayUtil.prod((int[])i_v.getShape());
            }
            if (Shape.isPlaceholderShape(i_v.getShape())) {
                sameDiff.addPropertyToResolve(this, i_v.getVarName());
            }
        } else {
            throw new IllegalArgumentException("Input must not null variable.");
        }
    }

    public BaseTransformOp(SameDiff sameDiff, SDVariable i_v, Object[] extraArgs) {
        this(sameDiff, i_v, i_v.getShape(), false, extraArgs);
    }

    public BaseTransformOp(INDArray x, INDArray z) {
        super(x, z);
        LinAlgExceptions.assertSameLength(x, z);
        LinAlgExceptions.assertSameShape(x, z);
    }

    public BaseTransformOp() {
    }

    public BaseTransformOp(INDArray x, INDArray z, long n) {
        super(x, z, n);
    }

    public BaseTransformOp(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
        if (y != null) {
            LinAlgExceptions.assertSameLength(x, y);
        }
        LinAlgExceptions.assertSameLength(x, z);
    }

    public BaseTransformOp(INDArray x) {
        super(x);
    }

    @Override
    public Op.Type opType() {
        if (this.args() == null || this.args().length == 1) {
            return Op.Type.TRANSFORM;
        }
        if (this.args().length == 2) {
            return Op.Type.PAIRWISE;
        }
        throw new ND4JIllegalStateException("Illegal number of args (can only be 1 or 2)");
    }

    @Override
    public List<int[]> calculateOutputShape() {
        ArrayList<int[]> ret = new ArrayList<int[]>(1);
        if (this.arg() == null) {
            throw new ND4JIllegalStateException("No arg found for op!");
        }
        INDArray arr = this.sameDiff.getArrForVarName(this.arg().getVarName());
        if (arr == null) {
            return Collections.emptyList();
        }
        ret.add(arr.shape());
        this.n = arr.length();
        return ret;
    }

    @Override
    public INDArray z() {
        if (this.z == null && this.sameDiff != null) {
            this.z = this.outputVariables()[0].getArr();
            if (this.z == null) {
                SDVariable var = this.outputVariables()[0];
                if (var.getShape() != null) {
                    this.z = var.storeAndAllocateNewArray();
                } else {
                    int[] argsShape = this.args()[0].getShape();
                    if (argsShape != null) {
                        this.sameDiff.putShapeForVarName(var.getVarName(), argsShape);
                        this.z = var.storeAndAllocateNewArray();
                    }
                }
            }
        }
        return this.z;
    }
}

