/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.BaseConvolutionConfig;

public class Pooling2DConfig
extends BaseConvolutionConfig {
    private int kh;
    private int kw;
    private int sy;
    private int sx;
    private int ph;
    private int pw;
    private int virtualHeight;
    private int virtualWidth;
    private double extra;
    private Pooling2D.Pooling2DType type;
    private Pooling2D.Divisor divisor;
    private boolean isSameMode;
    private int dh;
    private int dw;
    private boolean isNHWC;

    public Map<String, Object> toProperties() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("kh", this.kh);
        ret.put("kw", this.kw);
        ret.put("sy", this.sy);
        ret.put("sx", this.sx);
        ret.put("ph", this.ph);
        ret.put("pw", this.pw);
        ret.put("virtualHeight", this.virtualHeight);
        ret.put("virtualWidth", this.virtualWidth);
        ret.put("extra", this.extra);
        ret.put("type", this.type.toString());
        ret.put("isSameMode", this.isSameMode);
        ret.put("dh", this.dh);
        ret.put("dw", this.dw);
        ret.put("isNHWC", this.isNHWC);
        return ret;
    }

    private static Pooling2D.Divisor $default$divisor() {
        return Pooling2D.Divisor.EXCLUDE_PADDING;
    }

    private static int $default$dh() {
        return 1;
    }

    private static int $default$dw() {
        return 1;
    }

    private static boolean $default$isNHWC() {
        return false;
    }

    public static Pooling2DConfigBuilder builder() {
        return new Pooling2DConfigBuilder();
    }

    public Pooling2DConfig(int kh, int kw, int sy, int sx, int ph, int pw, int virtualHeight, int virtualWidth, double extra, Pooling2D.Pooling2DType type, Pooling2D.Divisor divisor, boolean isSameMode, int dh, int dw, boolean isNHWC) {
        this.kh = kh;
        this.kw = kw;
        this.sy = sy;
        this.sx = sx;
        this.ph = ph;
        this.pw = pw;
        this.virtualHeight = virtualHeight;
        this.virtualWidth = virtualWidth;
        this.extra = extra;
        this.type = type;
        this.divisor = divisor;
        this.isSameMode = isSameMode;
        this.dh = dh;
        this.dw = dw;
        this.isNHWC = isNHWC;
    }

    public int getKh() {
        return this.kh;
    }

    public int getKw() {
        return this.kw;
    }

    public int getSy() {
        return this.sy;
    }

    public int getSx() {
        return this.sx;
    }

    public int getPh() {
        return this.ph;
    }

    public int getPw() {
        return this.pw;
    }

    public int getVirtualHeight() {
        return this.virtualHeight;
    }

    public int getVirtualWidth() {
        return this.virtualWidth;
    }

    public double getExtra() {
        return this.extra;
    }

    public Pooling2D.Pooling2DType getType() {
        return this.type;
    }

    public Pooling2D.Divisor getDivisor() {
        return this.divisor;
    }

    public boolean isSameMode() {
        return this.isSameMode;
    }

    public int getDh() {
        return this.dh;
    }

    public int getDw() {
        return this.dw;
    }

    public boolean isNHWC() {
        return this.isNHWC;
    }

    public void setKh(int kh) {
        this.kh = kh;
    }

    public void setKw(int kw) {
        this.kw = kw;
    }

    public void setSy(int sy) {
        this.sy = sy;
    }

    public void setSx(int sx) {
        this.sx = sx;
    }

    public void setPh(int ph) {
        this.ph = ph;
    }

    public void setPw(int pw) {
        this.pw = pw;
    }

    public void setVirtualHeight(int virtualHeight) {
        this.virtualHeight = virtualHeight;
    }

    public void setVirtualWidth(int virtualWidth) {
        this.virtualWidth = virtualWidth;
    }

    public void setExtra(double extra) {
        this.extra = extra;
    }

    public void setType(Pooling2D.Pooling2DType type) {
        this.type = type;
    }

    public void setDivisor(Pooling2D.Divisor divisor) {
        this.divisor = divisor;
    }

    public void setSameMode(boolean isSameMode) {
        this.isSameMode = isSameMode;
    }

    public void setDh(int dh) {
        this.dh = dh;
    }

    public void setDw(int dw) {
        this.dw = dw;
    }

    public void setNHWC(boolean isNHWC) {
        this.isNHWC = isNHWC;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pooling2DConfig)) {
            return false;
        }
        Pooling2DConfig other = (Pooling2DConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getKh() != other.getKh()) {
            return false;
        }
        if (this.getKw() != other.getKw()) {
            return false;
        }
        if (this.getSy() != other.getSy()) {
            return false;
        }
        if (this.getSx() != other.getSx()) {
            return false;
        }
        if (this.getPh() != other.getPh()) {
            return false;
        }
        if (this.getPw() != other.getPw()) {
            return false;
        }
        if (this.getVirtualHeight() != other.getVirtualHeight()) {
            return false;
        }
        if (this.getVirtualWidth() != other.getVirtualWidth()) {
            return false;
        }
        if (Double.compare(this.getExtra(), other.getExtra()) != 0) {
            return false;
        }
        Pooling2D.Pooling2DType this$type = this.getType();
        Pooling2D.Pooling2DType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Pooling2D.Divisor this$divisor = this.getDivisor();
        Pooling2D.Divisor other$divisor = other.getDivisor();
        if (this$divisor == null ? other$divisor != null : !((Object)((Object)this$divisor)).equals((Object)other$divisor)) {
            return false;
        }
        if (this.isSameMode() != other.isSameMode()) {
            return false;
        }
        if (this.getDh() != other.getDh()) {
            return false;
        }
        if (this.getDw() != other.getDw()) {
            return false;
        }
        return this.isNHWC() == other.isNHWC();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Pooling2DConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getKh();
        result = result * 59 + this.getKw();
        result = result * 59 + this.getSy();
        result = result * 59 + this.getSx();
        result = result * 59 + this.getPh();
        result = result * 59 + this.getPw();
        result = result * 59 + this.getVirtualHeight();
        result = result * 59 + this.getVirtualWidth();
        long $extra = Double.doubleToLongBits(this.getExtra());
        result = result * 59 + (int)($extra >>> 32 ^ $extra);
        Pooling2D.Pooling2DType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Pooling2D.Divisor $divisor = this.getDivisor();
        result = result * 59 + ($divisor == null ? 43 : ((Object)((Object)$divisor)).hashCode());
        result = result * 59 + (this.isSameMode() ? 79 : 97);
        result = result * 59 + this.getDh();
        result = result * 59 + this.getDw();
        result = result * 59 + (this.isNHWC() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Pooling2DConfig(kh=" + this.getKh() + ", kw=" + this.getKw() + ", sy=" + this.getSy() + ", sx=" + this.getSx() + ", ph=" + this.getPh() + ", pw=" + this.getPw() + ", virtualHeight=" + this.getVirtualHeight() + ", virtualWidth=" + this.getVirtualWidth() + ", extra=" + this.getExtra() + ", type=" + (Object)((Object)this.getType()) + ", divisor=" + (Object)((Object)this.getDivisor()) + ", isSameMode=" + this.isSameMode() + ", dh=" + this.getDh() + ", dw=" + this.getDw() + ", isNHWC=" + this.isNHWC() + ")";
    }

    public static class Pooling2DConfigBuilder {
        private int kh;
        private int kw;
        private int sy;
        private int sx;
        private int ph;
        private int pw;
        private int virtualHeight;
        private int virtualWidth;
        private double extra;
        private Pooling2D.Pooling2DType type;
        private boolean divisor$set;
        private Pooling2D.Divisor divisor;
        private boolean isSameMode;
        private boolean dh$set;
        private int dh;
        private boolean dw$set;
        private int dw;
        private boolean isNHWC$set;
        private boolean isNHWC;

        Pooling2DConfigBuilder() {
        }

        public Pooling2DConfigBuilder kh(int kh) {
            this.kh = kh;
            return this;
        }

        public Pooling2DConfigBuilder kw(int kw) {
            this.kw = kw;
            return this;
        }

        public Pooling2DConfigBuilder sy(int sy) {
            this.sy = sy;
            return this;
        }

        public Pooling2DConfigBuilder sx(int sx) {
            this.sx = sx;
            return this;
        }

        public Pooling2DConfigBuilder ph(int ph) {
            this.ph = ph;
            return this;
        }

        public Pooling2DConfigBuilder pw(int pw) {
            this.pw = pw;
            return this;
        }

        public Pooling2DConfigBuilder virtualHeight(int virtualHeight) {
            this.virtualHeight = virtualHeight;
            return this;
        }

        public Pooling2DConfigBuilder virtualWidth(int virtualWidth) {
            this.virtualWidth = virtualWidth;
            return this;
        }

        public Pooling2DConfigBuilder extra(double extra) {
            this.extra = extra;
            return this;
        }

        public Pooling2DConfigBuilder type(Pooling2D.Pooling2DType type) {
            this.type = type;
            return this;
        }

        public Pooling2DConfigBuilder divisor(Pooling2D.Divisor divisor) {
            this.divisor = divisor;
            this.divisor$set = true;
            return this;
        }

        public Pooling2DConfigBuilder isSameMode(boolean isSameMode) {
            this.isSameMode = isSameMode;
            return this;
        }

        public Pooling2DConfigBuilder dh(int dh) {
            this.dh = dh;
            this.dh$set = true;
            return this;
        }

        public Pooling2DConfigBuilder dw(int dw) {
            this.dw = dw;
            this.dw$set = true;
            return this;
        }

        public Pooling2DConfigBuilder isNHWC(boolean isNHWC) {
            this.isNHWC = isNHWC;
            this.isNHWC$set = true;
            return this;
        }

        public Pooling2DConfig build() {
            Pooling2D.Divisor divisor = this.divisor;
            if (!this.divisor$set) {
                divisor = Pooling2DConfig.$default$divisor();
            }
            int dh = this.dh;
            if (!this.dh$set) {
                dh = Pooling2DConfig.$default$dh();
            }
            int dw = this.dw;
            if (!this.dw$set) {
                dw = Pooling2DConfig.$default$dw();
            }
            boolean isNHWC = this.isNHWC;
            if (!this.isNHWC$set) {
                isNHWC = Pooling2DConfig.$default$isNHWC();
            }
            return new Pooling2DConfig(this.kh, this.kw, this.sy, this.sx, this.ph, this.pw, this.virtualHeight, this.virtualWidth, this.extra, this.type, divisor, this.isSameMode, dh, dw, isNHWC);
        }

        public String toString() {
            return "Pooling2DConfig.Pooling2DConfigBuilder(kh=" + this.kh + ", kw=" + this.kw + ", sy=" + this.sy + ", sx=" + this.sx + ", ph=" + this.ph + ", pw=" + this.pw + ", virtualHeight=" + this.virtualHeight + ", virtualWidth=" + this.virtualWidth + ", extra=" + this.extra + ", type=" + (Object)((Object)this.type) + ", divisor=" + (Object)((Object)this.divisor) + ", isSameMode=" + this.isSameMode + ", dh=" + this.dh + ", dw=" + this.dw + ", isNHWC=" + this.isNHWC + ")";
        }
    }
}

