/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.ShapeOp;

public class RollAxis
extends ShapeOp {
    private int axis;

    public RollAxis(SameDiff sameDiff, int axis) {
        super(sameDiff);
        this.axis = axis;
    }

    public RollAxis(SameDiff sameDiff, SDVariable i_v, int axis) {
        super(sameDiff, i_v, false);
        this.axis = axis;
    }

    public RollAxis(SameDiff sameDiff, SDVariable i_v, int[] shape, boolean inPlace, Object[] extraArgs, int axis) {
        super(sameDiff, i_v, shape, inPlace, extraArgs);
        this.axis = axis;
    }

    public RollAxis() {
    }

    public RollAxis(INDArray x, INDArray z) {
        super(x, z);
    }

    public RollAxis(INDArray x, INDArray z, long n) {
        super(x, z, n);
    }

    public RollAxis(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public RollAxis(INDArray x) {
        super(x);
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("axis", this.axis);
        return ret;
    }

    @Override
    public void exec(int ... dimensions) {
        this.exec();
    }

    @Override
    public boolean isExecSpecial() {
        return true;
    }

    @Override
    public void exec() {
        if (this.x != this.z) {
            this.z.assign(this.x.transpose());
        } else {
            this.z = this.x.transpose();
        }
    }

    @Override
    public List<int[]> calculateOutputShape() {
        int i;
        ArrayList<int[]> ret = new ArrayList<int[]>();
        int[] inputShape = this.arg().getShape();
        int[] outputShape = new int[inputShape.length];
        outputShape[0] = inputShape[this.axis];
        for (i = 1; i <= this.axis; ++i) {
            outputShape[i] = inputShape[i - 1];
        }
        for (i = this.axis + 1; i < inputShape.length; ++i) {
            outputShape[i] = inputShape[i];
        }
        ret.add(outputShape);
        return ret;
    }

    @Override
    public int opNum() {
        return 0;
    }

    @Override
    public String opName() {
        return "rollaxis";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow opName found for " + this.opName());
    }

    @Override
    public INDArray z() {
        return this.x().transpose();
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable ret = this.outputVariables()[0];
        return Arrays.asList(ret);
    }
}

