/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import onnx.OnnxProto3;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.util.ArrayUtil;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Transpose
extends DynamicCustomOp {
    protected int[] permuteDims;

    public Transpose(SameDiff sameDiff, SDVariable i_v) {
        super(null, sameDiff, new SDVariable[]{i_v});
    }

    public Transpose() {
    }

    @Override
    public void resolvePropertiesFromSameDiffBeforeExecution() {
        super.resolvePropertiesFromSameDiffBeforeExecution();
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        LinkedHashMap<String, Map<String, PropertyMapping>> ret = new LinkedHashMap<String, Map<String, PropertyMapping>>();
        LinkedHashMap<String, PropertyMapping> map = new LinkedHashMap<String, PropertyMapping>();
        PropertyMapping mapping = PropertyMapping.builder().onnxAttrName("perm").propertyNames(new String[]{"permuteDims"}).tfInputPosition(1).build();
        map.put("permuteDims", mapping);
        ret.put(this.tensorflowName(), map);
        ret.put(this.onnxName(), map);
        return ret;
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("permuteDims", this.permuteDims);
        return ret;
    }

    @Override
    public String opName() {
        return "transpose";
    }

    @Override
    public String onnxName() {
        return "Transpose";
    }

    @Override
    public String tensorflowName() {
        return "Transpose";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        super.initFromTensorFlow(nodeDef, initWith, attributesForNode, graph);
        if (nodeDef.getInputCount() < 2) {
            return;
        }
        NodeDef permuteDimsNode = null;
        for (int i = 0; i < graph.getNodeCount(); ++i) {
            if (!graph.getNode(i).getName().equals(nodeDef.getInput(1))) continue;
            permuteDimsNode = graph.getNode(i);
        }
        INDArray permuteArrayOp = TFGraphMapper.getInstance().getNDArrayFromTensor("value", permuteDimsNode, graph);
        if (permuteArrayOp != null) {
            this.permuteDims = permuteArrayOp.data().asInt();
            for (int i = 0; i < this.permuteDims.length; ++i) {
                this.addIArgument(this.permuteDims[i]);
            }
        }
        if (this.arg().getShape() == null) {
            return;
        }
        INDArray arr = this.sameDiff.getArrForVarName(this.arg().getVarName());
        if (arr == null) {
            SDVariable arrVar = this.sameDiff.getVariable(this.arg().getVarName());
            arr = arrVar.getWeightInitScheme().create(arrVar.getShape());
            this.sameDiff.putArrayForVarName(this.arg().getVarName(), arr);
        }
        this.addInputArgument(arr);
        if (arr != null && this.permuteDims == null) {
            this.permuteDims = ArrayUtil.reverseCopy((int[])ArrayUtil.range((int)0, (int)arr.rank()));
        }
        if (this.permuteDims != null && this.permuteDims.length < this.arg().getShape().length) {
            throw new ND4JIllegalStateException("Illegal permute found. Not all dimensions specified");
        }
    }

    @Override
    public void initFromOnnx(OnnxProto3.NodeProto node, SameDiff initWith, Map<String, OnnxProto3.AttributeProto> attributesForNode, OnnxProto3.GraphProto graph) {
        if (attributesForNode.containsKey("perm")) {
            this.permuteDims = Ints.toArray(attributesForNode.get("perm").getIntsList());
        }
    }

    @Override
    public List<int[]> calculateOutputShape() {
        if (this.permuteDims == null && this.arg() != null && this.arg().getShape() != null) {
            this.permuteDims = ArrayUtil.reverseCopy((int[])ArrayUtil.range((int)0, (int)this.arg().getShape().length));
            int[] permutedShape = ArrayUtil.permute((int[])this.arg().getShape(), (int[])this.permuteDims);
            return Arrays.asList(new int[][]{permutedShape});
        }
        if (this.permuteDims != null && this.arg() != null && this.arg().getShape() != null) {
            int[] permutedShape = ArrayUtil.permute((int[])this.arg().getShape(), (int[])this.permuteDims);
            return Arrays.asList(new int[][]{permutedShape});
        }
        return Collections.emptyList();
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable ret = this.sameDiff.transpose(i_v.get(0));
        return Arrays.asList(ret);
    }
}

