/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu;

import java.util.List;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.cpu.NDArray;
import org.nd4j.linalg.cpu.blas.CpuLapack;
import org.nd4j.linalg.cpu.blas.CpuLevel1;
import org.nd4j.linalg.cpu.blas.CpuLevel2;
import org.nd4j.linalg.cpu.blas.CpuLevel3;
import org.nd4j.linalg.cpu.complex.ComplexDouble;
import org.nd4j.linalg.cpu.complex.ComplexFloat;
import org.nd4j.linalg.cpu.complex.ComplexNDArray;
import org.nd4j.linalg.factory.BaseNDArrayFactory;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;

public class CpuNDArrayFactory
extends BaseNDArrayFactory {
    public CpuNDArrayFactory() {
    }

    public CpuNDArrayFactory(DataBuffer.Type dtype, Character order) {
        super(dtype, order);
    }

    public CpuNDArrayFactory(DataBuffer.Type dtype, char order) {
        super(dtype, order);
    }

    public void createLevel1() {
        this.level1 = new CpuLevel1();
    }

    public void createLevel2() {
        this.level2 = new CpuLevel2();
    }

    public void createLevel3() {
        this.level3 = new CpuLevel3();
    }

    public void createLapack() {
        this.lapack = new CpuLapack();
    }

    public INDArray create(int[] shape, DataBuffer buffer) {
        return new NDArray(shape, buffer);
    }

    public IComplexFloat createFloat(float real, float imag) {
        return new ComplexFloat(real, imag);
    }

    public IComplexDouble createDouble(double real, double imag) {
        return new ComplexDouble(real, imag);
    }

    public INDArray create(double[][] data) {
        return new NDArray(data);
    }

    public INDArray create(double[][] data, char ordering) {
        return new NDArray(data, ordering);
    }

    public IComplexNDArray createComplex(INDArray arr) {
        return new ComplexNDArray(arr);
    }

    public IComplexNDArray createComplex(IComplexNumber[] data, int[] shape) {
        return new ComplexNDArray(data, shape);
    }

    public IComplexNDArray createComplex(List<IComplexNDArray> arrs, int[] shape) {
        return new ComplexNDArray(arrs, shape);
    }

    public INDArray create(DataBuffer data) {
        return new NDArray(data);
    }

    public IComplexNDArray createComplex(DataBuffer data) {
        return new ComplexNDArray(data);
    }

    public IComplexNDArray createComplex(DataBuffer data, int rows, int columns, int[] stride, int offset) {
        return new ComplexNDArray(data, new int[]{rows, columns}, stride, offset);
    }

    public INDArray create(DataBuffer data, int rows, int columns, int[] stride, int offset) {
        return new NDArray(data, new int[]{rows, columns}, stride, offset);
    }

    public IComplexNDArray createComplex(DataBuffer data, int[] shape, int[] stride, int offset) {
        return new ComplexNDArray(data, shape, stride, offset);
    }

    public IComplexNDArray createComplex(IComplexNumber[] data, int[] shape, int[] stride, int offset) {
        return this.createComplex(data, shape, stride, offset, this.order());
    }

    public IComplexNDArray createComplex(IComplexNumber[] data, int[] shape, int[] stride, int offset, char ordering) {
        return new ComplexNDArray(data, shape, stride, offset, ordering);
    }

    public IComplexNDArray createComplex(IComplexNumber[] data, int[] shape, int[] stride, char ordering) {
        return new ComplexNDArray(data, shape, stride, 0, ordering);
    }

    public IComplexNDArray createComplex(IComplexNumber[] data, int[] shape, int offset, char ordering) {
        return this.createComplex(data, shape, Nd4j.getComplexStrides((int[])shape), offset, ordering);
    }

    public IComplexNDArray createComplex(IComplexNumber[] data, int[] shape, char ordering) {
        return this.createComplex(data, shape, Nd4j.getComplexStrides((int[])shape), 0, ordering);
    }

    public IComplexNDArray createComplex(float[] data, int[] shape, int[] stride, int offset) {
        return new ComplexNDArray(data, shape, stride, offset);
    }

    public INDArray create(int[] shape, char ordering) {
        return new NDArray(shape, Nd4j.getStrides((int[])shape, (char)ordering), 0, ordering);
    }

    public INDArray create(DataBuffer data, int[] newShape, int[] newStride, int offset, char ordering) {
        return new NDArray(data, newShape, newStride, offset, ordering);
    }

    public IComplexNDArray createComplex(DataBuffer data, int[] newDims, int[] newStrides, int offset, char ordering) {
        return new ComplexNDArray(data, newDims, newStrides, offset, ordering);
    }

    public IComplexNDArray createComplex(float[] data, Character order) {
        return new ComplexNDArray(data, order);
    }

    public INDArray create(float[] data, int[] shape, int offset, Character order) {
        return new NDArray(data, shape, offset, order.charValue());
    }

    public INDArray create(float[] data, int rows, int columns, int[] stride, int offset, char ordering) {
        return new NDArray(data, new int[]{rows, columns}, stride, offset, ordering);
    }

    public INDArray create(double[] data, int[] shape, char ordering) {
        return new NDArray(Nd4j.createBuffer((double[])data), shape, ordering);
    }

    public INDArray create(List<INDArray> list, int[] shape, char ordering) {
        return new NDArray(list, shape, ordering);
    }

    public INDArray create(double[] data, int[] shape, int offset) {
        return new NDArray(Nd4j.createBuffer((double[])data), shape, offset);
    }

    public INDArray create(double[] data, int[] shape, int[] stride, int offset, char ordering) {
        return new NDArray(Nd4j.createBuffer((double[])data), shape, stride, offset, ordering);
    }

    public INDArray create(float[] data, int[] shape, int[] stride, int offset) {
        return new NDArray(data, shape, stride, offset);
    }

    public IComplexNDArray createComplex(double[] data, int[] shape, int[] stride, int offset) {
        return new ComplexNDArray(Nd4j.createBuffer((double[])data), shape, stride, offset);
    }

    public INDArray create(double[] data, int[] shape, int[] stride, int offset) {
        return new NDArray(data, shape, stride, offset);
    }

    public INDArray create(DataBuffer data, int[] shape) {
        return new NDArray(data, shape);
    }

    public IComplexNDArray createComplex(DataBuffer data, int[] shape) {
        return new ComplexNDArray(data, shape);
    }

    public IComplexNDArray createComplex(DataBuffer data, int[] shape, int[] stride) {
        return new ComplexNDArray(data, shape, stride);
    }

    public INDArray create(DataBuffer data, int[] shape, int[] stride, int offset) {
        return new NDArray(data, shape, stride, offset, Nd4j.order().charValue());
    }

    public INDArray create(List<INDArray> list, int[] shape) {
        return new NDArray(list, shape, Nd4j.getStrides((int[])shape));
    }

    public IComplexNDArray createComplex(double[] data, int[] shape, int[] stride, int offset, char ordering) {
        return new ComplexNDArray(ArrayUtil.floatCopyOf((double[])data), shape, stride, offset, ordering);
    }

    public IComplexNDArray createComplex(double[] data, int[] shape, int offset, char ordering) {
        return new ComplexNDArray(ArrayUtil.floatCopyOf((double[])data), shape, offset, ordering);
    }

    public IComplexNDArray createComplex(DataBuffer buffer, int[] shape, int offset, char ordering) {
        return new ComplexNDArray(buffer, shape, Nd4j.getComplexStrides((int[])shape), offset, ordering);
    }

    public IComplexNDArray createComplex(double[] data, int[] shape, int offset) {
        return new ComplexNDArray(ArrayUtil.floatCopyOf((double[])data), shape, offset);
    }

    public IComplexNDArray createComplex(DataBuffer buffer, int[] shape, int offset) {
        return new ComplexNDArray(buffer, shape, Nd4j.getComplexStrides((int[])shape), offset, Nd4j.order().charValue());
    }

    public IComplexNDArray createComplex(float[] data, int[] shape, int[] stride, int offset, char ordering) {
        return new ComplexNDArray(data, shape, stride, offset, ordering);
    }

    public INDArray create(float[][] floats) {
        return new NDArray(floats);
    }

    public INDArray create(float[][] data, char ordering) {
        return new NDArray(data, ordering);
    }

    public IComplexNDArray createComplex(float[] dim) {
        return new ComplexNDArray(dim);
    }

    public INDArray create(float[] data, int[] shape, int[] stride, int offset, char ordering) {
        return new NDArray(data, shape, stride, offset, ordering);
    }

    public INDArray create(DataBuffer buffer, int[] shape, int offset) {
        return new NDArray(buffer, shape, Nd4j.getStrides((int[])shape), offset);
    }

    public IComplexNDArray createComplex(float[] data, int[] shape, int offset, char ordering) {
        return new ComplexNDArray(data, shape, Nd4j.getComplexStrides((int[])shape, (char)ordering), offset, ordering);
    }

    public IComplexNDArray createComplex(float[] data, int[] shape, int offset) {
        return new ComplexNDArray(data, shape, offset);
    }

    public INDArray create(float[] data, int[] shape, int offset) {
        return new NDArray(data, shape, offset);
    }

    static {
        Nd4j.getBlasWrapper();
    }
}

