/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.function.Function;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Settings;

public class FulltextConfig
implements LoadableConfig {
    private static final String DEFAULT_ANALYZER = "standard";
    @Description(value="The name of the analyzer that the fulltext indexes should use by default.")
    public static final Setting<String> fulltext_default_analyzer = Settings.setting((String)"dbms.index.fulltext.default_analyzer", (Function)Settings.STRING, (String)"standard");
    @Description(value="Whether or not fulltext indexes should be eventually consistent by default or not.")
    public static final Setting<Boolean> eventually_consistent = Settings.setting((String)"dbms.index.fulltext.eventually_consistent", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="The eventually_consistent mode of the fulltext indexes works by queueing up index updates to be applied later in a background thread. This setting sets an upper bound on how many index updates are allowed to be in this queue at any one point in time. When it is reached, the commit process will slow down and wait for the index update applier thread to make some more room in the queue.")
    public static final Setting<Integer> eventually_consistent_index_update_queue_max_length = Settings.buildSetting((String)"dbms.index.fulltext.eventually_consistent_index_update_queue_max_length", (Function)Settings.INTEGER, (String)"10000").constraint(Settings.min((Comparable)Integer.valueOf(1))).constraint(Settings.max((Comparable)Integer.valueOf(50000000))).build();
}

