/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexSettingsKeys;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.Value;

final class FulltextIndexSettings {
    private FulltextIndexSettings() {
    }

    static String[] createPropertyNames(IndexDescriptor descriptor, TokenNameLookup tokenNameLookup) {
        int[] propertyIds = descriptor.schema().getPropertyIds();
        String[] propertyNames = new String[propertyIds.length];
        for (int i = 0; i < propertyIds.length; ++i) {
            propertyNames[i] = tokenNameLookup.propertyKeyGetName(propertyIds[i]);
        }
        return propertyNames;
    }

    static boolean isEventuallyConsistent(IndexDescriptor index) {
        BooleanValue eventuallyConsistent = (BooleanValue)index.getIndexConfig().getOrDefault(FulltextIndexSettingsKeys.EVENTUALLY_CONSISTENT, (Value)BooleanValue.FALSE);
        return eventuallyConsistent.booleanValue();
    }
}

