/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.StageExecution;
import org.neo4j.time.Clocks;

public class ExecutionSupervisor {
    private final Clock clock;
    private final ExecutionMonitor monitor;

    public ExecutionSupervisor(Clock clock, ExecutionMonitor monitor) {
        this.clock = clock;
        this.monitor = monitor;
    }

    public ExecutionSupervisor(ExecutionMonitor monitor) {
        this(Clocks.systemClock(), monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void supervise(StageExecution execution) {
        long startTime = this.currentTimeMillis();
        this.start(execution);
        try {
            while (!execution.awaitCompletion(this.monitor.checkIntervalMillis(), TimeUnit.MILLISECONDS)) {
                this.monitor.check(execution);
            }
        }
        catch (InterruptedException e) {
            execution.panic(e);
        }
        finally {
            this.end(execution, this.currentTimeMillis() - startTime);
        }
    }

    private long currentTimeMillis() {
        return this.clock.millis();
    }

    protected void end(StageExecution execution, long totalTimeMillis) {
        this.monitor.end(execution, totalTimeMillis);
    }

    protected void start(StageExecution execution) {
        this.monitor.start(execution);
    }
}

