/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.forseti;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.SettingChangeListener;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.forseti.ForsetiClient;
import org.neo4j.lock.LockType;
import org.neo4j.lock.ResourceType;
import org.neo4j.time.SystemNanoClock;

public class ForsetiLockManager
implements Locks {
    private final Config config;
    private final SettingChangeListener<Boolean> verboseDeadlocksSettingListener;
    private final ConcurrentMap<Long, Lock>[] lockMaps;
    private final ResourceType[] resourceTypes;
    private final AtomicLong clientIds = new AtomicLong();
    private final SystemNanoClock clock;
    private volatile boolean verboseDeadlocks;
    private volatile boolean closed;

    public ForsetiLockManager(Config config, SystemNanoClock clock, ResourceType ... resourceTypes) {
        this.config = config;
        int maxResourceId = ForsetiLockManager.findMaxResourceId(resourceTypes);
        this.lockMaps = new ConcurrentMap[maxResourceId];
        this.resourceTypes = new ResourceType[maxResourceId];
        for (ResourceType type : resourceTypes) {
            this.lockMaps[type.typeId()] = new ConcurrentHashMap<Long, Lock>(16, 0.6f, 512);
            this.resourceTypes[type.typeId()] = type;
        }
        this.clock = clock;
        this.verboseDeadlocks = (Boolean)config.get(GraphDatabaseInternalSettings.lock_manager_verbose_deadlocks);
        this.verboseDeadlocksSettingListener = (oldValue, newValue) -> {
            this.verboseDeadlocks = newValue;
        };
        config.addListener(GraphDatabaseInternalSettings.lock_manager_verbose_deadlocks, this.verboseDeadlocksSettingListener);
    }

    @Override
    public Locks.Client newClient() {
        if (this.closed) {
            throw new IllegalStateException(this + " already closed");
        }
        return new ForsetiClient(this.lockMaps, this.clock, this.verboseDeadlocks, this.clientIds.incrementAndGet());
    }

    @Override
    public void accept(Locks.Visitor out) {
        for (int i = 0; i < this.lockMaps.length; ++i) {
            if (this.lockMaps[i] == null) continue;
            ResourceType resourceType = this.resourceTypes[i];
            for (Map.Entry entry : this.lockMaps[i].entrySet()) {
                Lock lock = (Lock)entry.getValue();
                String description = lock.describeWaitList();
                LongSet transactionIds = lock.transactionIds();
                int lockIdentityHashCode = System.identityHashCode(lock);
                transactionIds.forEach((LongProcedure & Serializable)txId -> out.visit(lock.type(), resourceType, txId, (Long)entry.getKey(), description, 0L, lockIdentityHashCode));
            }
        }
    }

    private static int findMaxResourceId(ResourceType[] resourceTypes) {
        int max = 0;
        for (ResourceType resourceType : resourceTypes) {
            max = Math.max(resourceType.typeId(), max);
        }
        return max + 1;
    }

    @Override
    public void close() {
        this.config.removeListener(GraphDatabaseInternalSettings.lock_manager_verbose_deadlocks, this.verboseDeadlocksSettingListener);
        this.closed = true;
    }

    static interface Lock {
        public void copyHolderWaitListsInto(Set<ForsetiClient> var1);

        public ForsetiClient detectDeadlock(ForsetiClient var1);

        public String describeWaitList();

        public void collectOwners(Set<ForsetiClient> var1);

        public boolean isOwnedBy(ForsetiClient var1);

        public LockType type();

        public LongSet transactionIds();

        public boolean isClosed();
    }
}

