/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pickle;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class PrettyPrint {
    public static String printToStr(Object object) {
        StringWriter stringWriter = new StringWriter();
        try {
            PrettyPrint.print(object, stringWriter, false);
        }
        catch (IOException iOException) {
            stringWriter.write("<<error>>");
        }
        return stringWriter.toString().trim();
    }

    public static void print(Object object) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)System.out, "UTF-8");
        PrettyPrint.print(object, outputStreamWriter, true);
        outputStreamWriter.flush();
    }

    public static void print(Object object, OutputStream outputStream, boolean bl) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        PrettyPrint.print(object, outputStreamWriter, bl);
        outputStreamWriter.flush();
    }

    public static void print(Object object, Writer writer, boolean bl) throws IOException {
        if (object == null) {
            if (bl) {
                writer.write("null object\n");
            }
            writer.write("null\n");
            writer.flush();
            return;
        }
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz != null) {
            if (bl) {
                writer.write("array of " + clazz + "\n");
            }
            if (!clazz.isPrimitive()) {
                writer.write(Arrays.deepToString((Object[])object));
                writer.write("\n");
            } else if (clazz.equals(Integer.TYPE)) {
                writer.write(Arrays.toString((int[])object));
                writer.write("\n");
            } else if (clazz.equals(Double.TYPE)) {
                writer.write(Arrays.toString((double[])object));
                writer.write("\n");
            } else if (clazz.equals(Boolean.TYPE)) {
                writer.write(Arrays.toString((boolean[])object));
                writer.write("\n");
            } else if (clazz.equals(Short.TYPE)) {
                writer.write(Arrays.toString((short[])object));
                writer.write("\n");
            } else if (clazz.equals(Long.TYPE)) {
                writer.write(Arrays.toString((long[])object));
                writer.write("\n");
            } else if (clazz.equals(Float.TYPE)) {
                writer.write(Arrays.toString((float[])object));
                writer.write("\n");
            } else if (clazz.equals(Character.TYPE)) {
                writer.write(Arrays.toString((char[])object));
                writer.write("\n");
            } else if (clazz.equals(Byte.TYPE)) {
                writer.write(Arrays.toString((byte[])object));
                writer.write("\n");
            } else {
                writer.write("?????????\n");
            }
        } else if (object instanceof Set) {
            Set set = (Set)object;
            ArrayList<String> arrayList = new ArrayList<String>(set.size());
            for (Object e : set) {
                arrayList.add(e.toString());
            }
            Collections.sort(arrayList);
            if (bl) {
                writer.write(object.getClass().getName());
                writer.write("\n");
            }
            writer.write(arrayList.toString());
            writer.write("\n");
        } else if (object instanceof Map) {
            Map map = (Map)object;
            ArrayList<String> arrayList = new ArrayList<String>(map.size());
            for (Object k : map.keySet()) {
                arrayList.add(k.toString() + "=" + map.get(k));
            }
            Collections.sort(arrayList);
            if (bl) {
                writer.write(object.getClass().getName());
                writer.write("\n");
            }
            writer.write(arrayList.toString());
            writer.write("\n");
        } else if (object instanceof Collection) {
            if (bl) {
                writer.write(object.getClass().getName());
                writer.write("\n");
            }
            writer.write(object.toString());
            writer.write("\n");
        } else if (object instanceof String) {
            if (bl) {
                writer.write("String\n");
            }
            writer.write(object.toString());
            writer.write("\n");
        } else if (object instanceof Calendar) {
            if (bl) {
                writer.write("java.util.Calendar\n");
            }
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.UK);
            Calendar calendar = (Calendar)object;
            writer.write(dateFormat.format(calendar.getTime()) + " millisec=" + calendar.get(14) + "\n");
        } else {
            if (bl) {
                writer.write(object.getClass().getName());
                writer.write("\n");
            }
            writer.write(object.toString());
            writer.write("\n");
        }
        writer.flush();
    }
}

