/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pickle.objects;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Locale;

public class TimeDelta
implements Serializable {
    private static final long serialVersionUID = 5793744158850914421L;
    public int days;
    public int seconds;
    public int microseconds;
    public double total_seconds;

    public TimeDelta(int n, int n2, int n3) {
        this.days = n;
        this.seconds = n2;
        this.microseconds = n3;
        this.total_seconds = (double)(n * 86400 + n2) + (double)n3 / 1000000.0;
    }

    public String toString() {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.UK);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMaximumFractionDigits(6);
        String string = numberFormat.format(this.total_seconds);
        return String.format("Timedelta: %d days, %d seconds, %d microseconds (total: %s seconds)", this.days, this.seconds, this.microseconds, string);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.days;
        n = 31 * n + this.microseconds;
        n = 31 * n + this.seconds;
        long l = Double.doubleToLongBits(this.total_seconds);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof TimeDelta)) {
            return false;
        }
        TimeDelta timeDelta = (TimeDelta)object;
        return this.days == timeDelta.days && this.seconds == timeDelta.seconds && this.microseconds == timeDelta.microseconds && this.total_seconds == timeDelta.total_seconds;
    }
}

