/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pyro.serializer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import net.razorvine.pyro.Config;
import net.razorvine.pyro.PyroException;
import net.razorvine.pyro.serializer.PickleSerializer;
import net.razorvine.pyro.serializer.SerpentSerializer;

public abstract class PyroSerializer {
    protected static Map<Config.SerializerType, PyroSerializer> AvailableSerializers = new HashMap<Config.SerializerType, PyroSerializer>();
    protected static PickleSerializer pickleSerializer = new PickleSerializer();
    protected static SerpentSerializer serpentSerializer;

    public abstract int getSerializerId();

    public abstract byte[] serializeCall(String var1, String var2, Object[] var3, Map<String, Object> var4) throws IOException;

    public abstract byte[] serializeData(Object var1) throws IOException;

    public abstract Object deserializeData(byte[] var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PyroSerializer getFor(Config.SerializerType serializerType) {
        switch (serializerType) {
            case pickle: {
                return pickleSerializer;
            }
            case serpent: {
                Class<PyroSerializer> clazz = PyroSerializer.class;
                synchronized (PyroSerializer.class) {
                    if (serpentSerializer == null) {
                        try {
                            serpentSerializer = new SerpentSerializer();
                            if (PyroSerializer.compareLibraryVersions("1.5", "1.4") < 0) {
                                throw new RuntimeException("serpent version 1.4 (or newer) is required");
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return serpentSerializer;
                        }
                        catch (LinkageError linkageError) {
                            throw new PyroException("serpent serializer unavailable", linkageError);
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return serpentSerializer;
                }
            }
        }
        throw new IllegalArgumentException("unrecognised serializer type: " + (Object)((Object)serializerType));
    }

    public static int compareLibraryVersions(String string, String string2) {
        int n;
        Scanner scanner = new Scanner(string);
        Scanner scanner2 = new Scanner(string2);
        scanner.useDelimiter("\\.");
        scanner2.useDelimiter("\\.");
        while (scanner.hasNextInt() && scanner2.hasNextInt()) {
            int n2;
            n = scanner.nextInt();
            if (n < (n2 = scanner2.nextInt())) {
                scanner.close();
                scanner2.close();
                return -1;
            }
            if (n <= n2) continue;
            scanner.close();
            scanner2.close();
            return 1;
        }
        n = 0;
        if (scanner.hasNextInt()) {
            n = 1;
        }
        scanner.close();
        scanner2.close();
        return n;
    }
}

