/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.availability;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.actuate.autoconfigure.availability.AvailabilityProbesHealthEndpointGroup;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.actuate.health.AdditionalHealthEndpointPath;
import org.springframework.boot.actuate.health.HealthEndpointGroup;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.util.Assert;

class AvailabilityProbesHealthEndpointGroups
implements HealthEndpointGroups {
    private final HealthEndpointGroups groups;
    private final Map<String, HealthEndpointGroup> probeGroups;
    private final Set<String> names;

    AvailabilityProbesHealthEndpointGroups(HealthEndpointGroups groups, boolean addAdditionalPaths) {
        Assert.notNull((Object)groups, (String)"Groups must not be null");
        this.groups = groups;
        this.probeGroups = this.createProbeGroups(addAdditionalPaths);
        LinkedHashSet<String> names = new LinkedHashSet<String>(groups.getNames());
        names.addAll(this.probeGroups.keySet());
        this.names = Collections.unmodifiableSet(names);
    }

    private Map<String, HealthEndpointGroup> createProbeGroups(boolean addAdditionalPaths) {
        LinkedHashMap<String, AvailabilityProbesHealthEndpointGroup> probeGroups = new LinkedHashMap<String, AvailabilityProbesHealthEndpointGroup>();
        probeGroups.put("liveness", this.createProbeGroup(addAdditionalPaths, "/livez", "livenessState"));
        probeGroups.put("readiness", this.createProbeGroup(addAdditionalPaths, "/readyz", "readinessState"));
        return Collections.unmodifiableMap(probeGroups);
    }

    private AvailabilityProbesHealthEndpointGroup createProbeGroup(boolean addAdditionalPath, String path, String members) {
        AdditionalHealthEndpointPath additionalPath = !addAdditionalPath ? null : AdditionalHealthEndpointPath.of((WebServerNamespace)WebServerNamespace.SERVER, (String)path);
        return new AvailabilityProbesHealthEndpointGroup(additionalPath, members);
    }

    public HealthEndpointGroup getPrimary() {
        return this.groups.getPrimary();
    }

    public Set<String> getNames() {
        return this.names;
    }

    public HealthEndpointGroup get(String name) {
        HealthEndpointGroup group = this.groups.get(name);
        if (group == null) {
            group = this.probeGroups.get(name);
        }
        return group;
    }

    static boolean containsAllProbeGroups(HealthEndpointGroups groups) {
        Set names = groups.getNames();
        return names.contains("liveness") && names.contains("readiness");
    }
}

