/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.servlet.ServletContainer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.WebEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.actuate.endpoint.web.jersey.JerseyHealthEndpointAdditionalPathResourceFactory;
import org.springframework.boot.actuate.endpoint.web.servlet.AdditionalHealthEndpointPathsWebMvcHandlerMapping;
import org.springframework.boot.actuate.health.HealthContributorRegistry;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.boot.actuate.health.HealthEndpointWebExtension;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jersey.JerseyProperties;
import org.springframework.boot.autoconfigure.jersey.ResourceConfigCustomizer;
import org.springframework.boot.autoconfigure.web.servlet.DefaultJerseyApplicationPath;
import org.springframework.boot.autoconfigure.web.servlet.JerseyApplicationPath;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnBean(value={HealthEndpoint.class})
@ConditionalOnAvailableEndpoint(endpoint=HealthEndpoint.class, exposure={EndpointExposure.WEB})
class HealthEndpointWebExtensionConfiguration {
    HealthEndpointWebExtensionConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    HealthEndpointWebExtension healthEndpointWebExtension(HealthContributorRegistry healthContributorRegistry, HealthEndpointGroups groups) {
        return new HealthEndpointWebExtension(healthContributorRegistry, groups);
    }

    private static ExposableWebEndpoint getHealthEndpoint(WebEndpointsSupplier webEndpointsSupplier) {
        Collection webEndpoints = webEndpointsSupplier.getEndpoints();
        return webEndpoints.stream().filter(endpoint -> endpoint.getEndpointId().equals((Object)HealthEndpoint.ID)).findFirst().get();
    }

    static class JerseyAdditionalHealthEndpointPathsResourcesRegistrar
    implements ResourceConfigCustomizer {
        private final ExposableWebEndpoint endpoint;
        private final HealthEndpointGroups groups;

        JerseyAdditionalHealthEndpointPathsResourcesRegistrar(ExposableWebEndpoint endpoint, HealthEndpointGroups groups) {
            this.endpoint = endpoint;
            this.groups = groups;
        }

        public void customize(ResourceConfig config) {
            this.register(config);
        }

        private void register(ResourceConfig config) {
            EndpointMapping mapping = new EndpointMapping("");
            JerseyHealthEndpointAdditionalPathResourceFactory resourceFactory = new JerseyHealthEndpointAdditionalPathResourceFactory(WebServerNamespace.SERVER, this.groups);
            Collection endpointResources = resourceFactory.createEndpointResources(mapping, Collections.singletonList(this.endpoint), null, null, false).stream().filter(Objects::nonNull).collect(Collectors.toList());
            this.register(endpointResources, config);
        }

        private void register(Collection<Resource> resources, ResourceConfig config) {
            config.registerResources(new HashSet<Resource>(resources));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ResourceConfig.class})
    @ConditionalOnMissingClass(value={"org.springframework.web.servlet.DispatcherServlet"})
    static class JerseyAdditionalHealthEndpointPathsConfiguration {
        JerseyAdditionalHealthEndpointPathsConfiguration() {
        }

        @Bean
        JerseyAdditionalHealthEndpointPathsResourcesRegistrar jerseyAdditionalHealthEndpointPathsResourcesRegistrar(WebEndpointsSupplier webEndpointsSupplier, HealthEndpointGroups healthEndpointGroups) {
            ExposableWebEndpoint health = HealthEndpointWebExtensionConfiguration.getHealthEndpoint(webEndpointsSupplier);
            return new JerseyAdditionalHealthEndpointPathsResourcesRegistrar(health, healthEndpointGroups);
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnMissingBean(value={ResourceConfig.class})
        @EnableConfigurationProperties(value={JerseyProperties.class})
        static class JerseyInfrastructureConfiguration {
            JerseyInfrastructureConfiguration() {
            }

            @Bean
            @ConditionalOnMissingBean(value={JerseyApplicationPath.class})
            JerseyApplicationPath jerseyApplicationPath(JerseyProperties properties, ResourceConfig config) {
                return new DefaultJerseyApplicationPath(properties.getApplicationPath(), config);
            }

            @Bean
            ResourceConfig resourceConfig(ObjectProvider<ResourceConfigCustomizer> resourceConfigCustomizers) {
                ResourceConfig resourceConfig = new ResourceConfig();
                resourceConfigCustomizers.orderedStream().forEach(customizer -> customizer.customize(resourceConfig));
                return resourceConfig;
            }

            @Bean
            ServletRegistrationBean<ServletContainer> jerseyServletRegistration(JerseyApplicationPath jerseyApplicationPath, ResourceConfig resourceConfig) {
                return new ServletRegistrationBean((Servlet)new ServletContainer(resourceConfig), new String[]{jerseyApplicationPath.getUrlMapping()});
            }
        }
    }

    @ConditionalOnBean(value={DispatcherServlet.class})
    static class MvcAdditionalHealthEndpointPathsConfiguration {
        MvcAdditionalHealthEndpointPathsConfiguration() {
        }

        @Bean
        AdditionalHealthEndpointPathsWebMvcHandlerMapping healthEndpointWebMvcHandlerMapping(WebEndpointsSupplier webEndpointsSupplier, HealthEndpointGroups groups) {
            ExposableWebEndpoint health = HealthEndpointWebExtensionConfiguration.getHealthEndpoint(webEndpointsSupplier);
            return new AdditionalHealthEndpointPathsWebMvcHandlerMapping(health, groups.getAllWithAdditionalPath(WebServerNamespace.SERVER));
        }
    }
}

