/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing;

import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.annotation.DefaultNewSpanParser;
import io.micrometer.tracing.annotation.ImperativeMethodInvocationProcessor;
import io.micrometer.tracing.annotation.MethodInvocationProcessor;
import io.micrometer.tracing.annotation.NewSpanParser;
import io.micrometer.tracing.annotation.SpanAspect;
import io.micrometer.tracing.annotation.SpanTagAnnotationHandler;
import io.micrometer.tracing.handler.DefaultTracingObservationHandler;
import io.micrometer.tracing.handler.PropagatingReceiverTracingObservationHandler;
import io.micrometer.tracing.handler.PropagatingSenderTracingObservationHandler;
import io.micrometer.tracing.propagation.Propagator;
import org.aspectj.weaver.Advice;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@AutoConfiguration
@ConditionalOnClass(value={Tracer.class})
@ConditionalOnBean(value={Tracer.class})
public class MicrometerTracingAutoConfiguration {
    public static final int DEFAULT_TRACING_OBSERVATION_HANDLER_ORDER = 2147482647;
    public static final int RECEIVER_TRACING_OBSERVATION_HANDLER_ORDER = 1000;
    public static final int SENDER_TRACING_OBSERVATION_HANDLER_ORDER = 2000;

    @Bean
    @ConditionalOnMissingBean
    @Order(value=2147482647)
    public DefaultTracingObservationHandler defaultTracingObservationHandler(Tracer tracer) {
        return new DefaultTracingObservationHandler(tracer);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={Propagator.class})
    @Order(value=2000)
    public PropagatingSenderTracingObservationHandler<?> propagatingSenderTracingObservationHandler(Tracer tracer, Propagator propagator) {
        return new PropagatingSenderTracingObservationHandler(tracer, propagator);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={Propagator.class})
    @Order(value=1000)
    public PropagatingReceiverTracingObservationHandler<?> propagatingReceiverTracingObservationHandler(Tracer tracer, Propagator propagator) {
        return new PropagatingReceiverTracingObservationHandler(tracer, propagator);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Advice.class})
    @ConditionalOnProperty(prefix="micrometer.observations.annotations", name={"enabled"}, havingValue="true")
    static class SpanAspectConfiguration {
        SpanAspectConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={NewSpanParser.class})
        DefaultNewSpanParser newSpanParser() {
            return new DefaultNewSpanParser();
        }

        @Bean
        @ConditionalOnMissingBean(value={MethodInvocationProcessor.class})
        ImperativeMethodInvocationProcessor imperativeMethodInvocationProcessor(NewSpanParser newSpanParser, Tracer tracer, ObjectProvider<SpanTagAnnotationHandler> spanTagAnnotationHandler) {
            ImperativeMethodInvocationProcessor methodInvocationProcessor = new ImperativeMethodInvocationProcessor(newSpanParser, tracer);
            spanTagAnnotationHandler.ifAvailable(x$0 -> methodInvocationProcessor.setSpanTagAnnotationHandler(x$0));
            return methodInvocationProcessor;
        }

        @Bean
        @ConditionalOnMissingBean
        SpanAspect spanAspect(MethodInvocationProcessor methodInvocationProcessor) {
            return new SpanAspect(methodInvocationProcessor);
        }
    }
}

