/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.remote.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.devtools.autoconfigure.OptionalLiveReloadServer;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;

class DelayedLiveReloadTrigger
implements Runnable {
    private static final long SHUTDOWN_TIME = 1000L;
    private static final long SLEEP_TIME = 500L;
    private static final long TIMEOUT = 30000L;
    private static final Log logger = LogFactory.getLog(DelayedLiveReloadTrigger.class);
    private final OptionalLiveReloadServer liveReloadServer;
    private final ClientHttpRequestFactory requestFactory;
    private final URI uri;
    private long shutdownTime = 1000L;
    private long sleepTime = 500L;
    private long timeout = 30000L;

    DelayedLiveReloadTrigger(OptionalLiveReloadServer liveReloadServer, ClientHttpRequestFactory requestFactory, String url) {
        Assert.notNull((Object)liveReloadServer, (String)"'liveReloadServer' must not be null");
        Assert.notNull((Object)requestFactory, (String)"'requestFactory' must not be null");
        Assert.hasLength((String)url, (String)"'url' must not be empty");
        this.liveReloadServer = liveReloadServer;
        this.requestFactory = requestFactory;
        try {
            this.uri = new URI(url);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    protected void setTimings(long shutdown, long sleep, long timeout) {
        this.shutdownTime = shutdown;
        this.sleepTime = sleep;
        this.timeout = timeout;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(this.shutdownTime);
            long start = System.currentTimeMillis();
            while (!this.isUp()) {
                long runTime = System.currentTimeMillis() - start;
                if (runTime > this.timeout) {
                    return;
                }
                Thread.sleep(this.sleepTime);
            }
            logger.info((Object)"Remote server has changed, triggering LiveReload");
            this.liveReloadServer.triggerReload();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private boolean isUp() {
        boolean bl;
        block8: {
            ClientHttpRequest request = this.createRequest();
            ClientHttpResponse response = request.execute();
            try {
                boolean bl2 = bl = response.getStatusCode() == HttpStatus.OK;
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    return false;
                }
            }
            response.close();
        }
        return bl;
    }

    private ClientHttpRequest createRequest() throws IOException {
        return this.requestFactory.createRequest(this.uri, HttpMethod.GET);
    }
}

