/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.service.registry.HttpServiceGroup;

final class GroupsMetadata {
    private final Map<String, DefaultRegistration> groupMap = new LinkedHashMap<String, DefaultRegistration>();

    public GroupsMetadata() {
        this(Collections.emptyList());
    }

    GroupsMetadata(Iterable<DefaultRegistration> registrations) {
        registrations.forEach(registration -> this.groupMap.put(registration.name(), (DefaultRegistration)registration));
    }

    public Registration getOrCreateGroup(String groupName, HttpServiceGroup.ClientType clientType) {
        return this.groupMap.computeIfAbsent(groupName, name -> new DefaultRegistration((String)name, clientType)).clientType(clientType);
    }

    public void mergeWith(GroupsMetadata other) {
        other.groupMap.values().forEach(registration -> this.getOrCreateGroup(registration.name(), registration.clientType()).httpServiceTypeNames().addAll(registration.httpServiceTypeNames()));
    }

    public void forEachRegistration(BiConsumer<String, Set<String>> consumer) {
        this.groupMap.values().forEach(registration -> consumer.accept(registration.name(), registration.httpServiceTypeNames()));
    }

    public Collection<HttpServiceGroup> groups() {
        return this.groupMap.values().stream().map(DefaultRegistration::toHttpServiceGroup).toList();
    }

    public static Class<?> loadClass(String type) {
        try {
            return ClassUtils.forName((String)type, (ClassLoader)GroupsMetadata.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Failed to load '" + type + "'", ex);
        }
    }

    Stream<DefaultRegistration> registrations() {
        return this.groupMap.values().stream();
    }

    static class DefaultRegistration
    implements Registration {
        private final String name;
        private HttpServiceGroup.ClientType clientType;
        private final Set<String> typeNames;

        DefaultRegistration(String name, HttpServiceGroup.ClientType clientType) {
            this(name, clientType, new LinkedHashSet<String>());
        }

        DefaultRegistration(String name, HttpServiceGroup.ClientType clientType, Set<String> typeNames) {
            this.name = name;
            this.clientType = clientType;
            this.typeNames = typeNames;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public HttpServiceGroup.ClientType clientType() {
            return this.clientType;
        }

        @Override
        public Set<String> httpServiceTypeNames() {
            return this.typeNames;
        }

        public DefaultRegistration clientType(HttpServiceGroup.ClientType other) {
            if (this.clientType.isUnspecified()) {
                this.clientType = other;
            } else {
                Assert.isTrue((this.clientType == other || other.isUnspecified() ? 1 : 0) != 0, (String)("ClientType conflict for HttpServiceGroup '" + this.name + "'"));
            }
            return this;
        }

        public HttpServiceGroup toHttpServiceGroup() {
            return new RegisteredGroup(this.name, this.clientType.isUnspecified() ? HttpServiceGroup.ClientType.REST_CLIENT : this.clientType, this.typeNames.stream().map(GroupsMetadata::loadClass).collect(Collectors.toSet()));
        }

        public String toString() {
            return "Group '" + this.name + "', ClientType." + String.valueOf((Object)this.clientType) + ", " + String.valueOf(this.typeNames);
        }
    }

    static interface Registration {
        public String name();

        public HttpServiceGroup.ClientType clientType();

        public Set<String> httpServiceTypeNames();
    }

    private record RegisteredGroup(String name, HttpServiceGroup.ClientType clientType, Set<Class<?>> httpServiceTypes) implements HttpServiceGroup
    {
    }
}

