/*
 * Decompiled with CFR 0.152.
 */
package tachyon.security.authentication;

import java.io.IOException;
import java.net.InetSocketAddress;
import javax.security.sasl.SaslException;
import tachyon.conf.TachyonConf;
import tachyon.org.apache.thrift.transport.TFramedTransport;
import tachyon.org.apache.thrift.transport.TSocket;
import tachyon.org.apache.thrift.transport.TTransport;
import tachyon.org.apache.thrift.transport.TTransportFactory;
import tachyon.security.LoginUser;
import tachyon.security.authentication.AuthType;
import tachyon.security.authentication.PlainSaslUtils;
import tachyon.util.network.NetworkAddressUtils;

public final class AuthenticationUtils {
    public static TTransportFactory getServerTransportFactory(TachyonConf tachyonConf) throws SaslException {
        AuthType authType = tachyonConf.getEnum("tachyon.security.authentication.type", AuthType.class);
        switch (authType) {
            case NOSASL: {
                return new TFramedTransport.Factory();
            }
            case SIMPLE: 
            case CUSTOM: {
                return PlainSaslUtils.getPlainServerTransportFactory(authType, tachyonConf);
            }
            case KERBEROS: {
                throw new UnsupportedOperationException("getServerTransportFactory: Kerberos is not supported currently.");
            }
        }
        throw new UnsupportedOperationException("getServerTransportFactory: Unsupported authentication type: " + authType.getAuthName());
    }

    public static TTransport getClientTransport(TachyonConf tachyonConf, InetSocketAddress serverAddress) throws IOException {
        AuthType authType = tachyonConf.getEnum("tachyon.security.authentication.type", AuthType.class);
        TSocket tTransport = AuthenticationUtils.createTSocket(serverAddress);
        switch (authType) {
            case NOSASL: {
                return new TFramedTransport(tTransport);
            }
            case SIMPLE: 
            case CUSTOM: {
                String username = LoginUser.get(tachyonConf).getName();
                return PlainSaslUtils.getPlainClientTransport(username, "noPassword", tTransport);
            }
            case KERBEROS: {
                throw new UnsupportedOperationException("getClientTransport: Kerberos is not supported currently.");
            }
        }
        throw new UnsupportedOperationException("getClientTransport: Unsupported authentication type: " + authType.getAuthName());
    }

    public static TSocket createTSocket(InetSocketAddress address) {
        return new TSocket(NetworkAddressUtils.getFqdnHost(address), address.getPort(), 30000);
    }

    private AuthenticationUtils() {
    }
}

