/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.concurrent.atomic.AtomicReferenceArray;
import org.tensorflow.AbstractOperation;
import org.tensorflow.DataType;
import org.tensorflow.EagerSession;
import org.tensorflow.Tensor;

class EagerOperation
extends AbstractOperation {
    private final EagerSession session;
    private final NativeReference nativeRef;
    private final String type;
    private final String name;
    private final AtomicReferenceArray<Tensor<?>> outputTensors;

    EagerOperation(EagerSession session, long opNativeHandle, long[] outputNativeHandles, String type, String name) {
        this.session = session;
        this.type = type;
        this.name = name;
        this.nativeRef = new NativeReference(session, this, opNativeHandle, outputNativeHandles);
        this.outputTensors = new AtomicReferenceArray(outputNativeHandles.length);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public int numOutputs() {
        return this.nativeRef.outputHandles.length;
    }

    @Override
    public int outputListLength(String name) {
        return EagerOperation.outputListLength(this.nativeRef.opHandle, name);
    }

    @Override
    public int inputListLength(String name) {
        return EagerOperation.inputListLength(this.nativeRef.opHandle, name);
    }

    @Override
    public long getUnsafeNativeHandle(int outputIndex) {
        return this.nativeRef.outputHandles[outputIndex];
    }

    @Override
    public long[] shape(int outputIndex) {
        Tensor<?> tensor = this.outputTensors.get(outputIndex);
        if (tensor != null) {
            return tensor.shape();
        }
        long outputNativeHandle = this.getUnsafeNativeHandle(outputIndex);
        long[] shape = new long[EagerOperation.numDims(outputNativeHandle)];
        for (int i = 0; i < shape.length; ++i) {
            shape[i] = EagerOperation.dim(outputNativeHandle, i);
        }
        return shape;
    }

    @Override
    public DataType dtype(int outputIndex) {
        Tensor<?> tensor = this.outputTensors.get(outputIndex);
        if (tensor != null) {
            return tensor.dataType();
        }
        long outputNativeHandle = this.getUnsafeNativeHandle(outputIndex);
        return DataType.fromC(EagerOperation.dataType(outputNativeHandle));
    }

    @Override
    public Tensor<?> tensor(int outputIndex) {
        Tensor<?> tensor = this.outputTensors.get(outputIndex);
        if (tensor == null) {
            tensor = this.resolveTensor(outputIndex);
        }
        return tensor;
    }

    private Tensor<?> resolveTensor(int outputIndex) {
        long tensorNativeHandle = EagerOperation.resolveTensorHandle(this.getUnsafeNativeHandle(outputIndex));
        Tensor<?> tensor = Tensor.fromHandle(tensorNativeHandle, this.session);
        if (!this.outputTensors.compareAndSet(outputIndex, null, tensor)) {
            tensor.close();
            tensor = this.outputTensors.get(outputIndex);
        }
        return tensor;
    }

    private static native void delete(long var0);

    private static native void deleteTensorHandle(long var0);

    private static native long resolveTensorHandle(long var0);

    private static native int outputListLength(long var0, String var2);

    private static native int inputListLength(long var0, String var2);

    private static native int dataType(long var0);

    private static native int numDims(long var0);

    private static native long dim(long var0, int var2);

    private static class NativeReference
    extends EagerSession.NativeReference {
        private long opHandle;
        private final long[] outputHandles;

        NativeReference(EagerSession session, EagerOperation operation, long opHandle, long[] outputHandles) {
            super(session, operation);
            this.opHandle = opHandle;
            this.outputHandles = outputHandles;
        }

        @Override
        void delete() {
            if (this.opHandle != 0L) {
                for (int i = 0; i < this.outputHandles.length; ++i) {
                    if (this.outputHandles[i] == 0L) continue;
                    EagerOperation.deleteTensorHandle(this.outputHandles[i]);
                    this.outputHandles[i] = 0L;
                }
                EagerOperation.delete(this.opHandle);
                this.opHandle = 0L;
            }
        }
    }
}

