/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class RaggedTensorFromVariant<U extends Number, T>
extends PrimitiveOp {
    private List<Output<U>> outputNestedSplits;
    private Output<T> outputDenseValues;

    public static <U extends Number, T> RaggedTensorFromVariant<U, T> create(Scope scope, Operand<?> encodedRagged, Long inputRaggedRank, Long outputRaggedRank, Class<T> Tvalues, Class<U> Tsplits) {
        OperationBuilder opBuilder = scope.env().opBuilder("RaggedTensorFromVariant", scope.makeOpName("RaggedTensorFromVariant"));
        opBuilder.addInput(encodedRagged.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("input_ragged_rank", inputRaggedRank);
        opBuilder.setAttr("output_ragged_rank", outputRaggedRank);
        opBuilder.setAttr("Tvalues", DataType.fromClass(Tvalues));
        opBuilder.setAttr("Tsplits", DataType.fromClass(Tsplits));
        return new RaggedTensorFromVariant<U, T>(opBuilder.build());
    }

    public List<Output<U>> outputNestedSplits() {
        return this.outputNestedSplits;
    }

    public Output<T> outputDenseValues() {
        return this.outputDenseValues;
    }

    private RaggedTensorFromVariant(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int outputNestedSplitsLength = operation.outputListLength("output_nested_splits");
        this.outputNestedSplits = Arrays.asList(operation.outputList(outputIdx, outputNestedSplitsLength));
        outputIdx += outputNestedSplitsLength;
        this.outputDenseValues = operation.output(outputIdx++);
    }
}

