/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.flowservicecomponent;

import java.util.UUID;
import org.tinygroup.cepcore.CEPCore;
import org.tinygroup.context.Context;
import org.tinygroup.event.Event;
import org.tinygroup.event.ServiceRequest;
import org.tinygroup.flow.ComponentInterface;

public class CallServiceComponent
implements ComponentInterface {
    private String serviceId;
    private String serviceName;
    private String groupId;
    private String artifactId;
    private String version;
    private CEPCore cepCore;

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void execute(Context context) {
        Event event = this.getEvent(context);
        this.cepCore.process(event);
    }

    private Event getEvent(Context context) {
        Event event = new Event();
        event.setEventId(UUID.randomUUID().toString());
        ServiceRequest serviceRequest = new ServiceRequest();
        serviceRequest.setContext(context);
        if (this.notNull(this.serviceId)) {
            serviceRequest.setServiceId(this.serviceId);
        }
        event.setServiceRequest(serviceRequest);
        return event;
    }

    private boolean notNull(String str) {
        return str != null && !"".equals(str);
    }

    public CEPCore getCepCore() {
        return this.cepCore;
    }

    public void setCepCore(CEPCore cepCore) {
        this.cepCore = cepCore;
    }
}

