/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.zkoss.lang.Objects;

public class Locales {
    private static final InheritableThreadLocal<Locale> _thdLocale;
    private static final Map<Locale, Locale> _founds;

    public static final Locale getCurrent() {
        Locale l = (Locale)_thdLocale.get();
        return l != null ? l : Locale.getDefault();
    }

    public static final boolean testCurrent(String lang, String country) {
        Locale l = Locales.getCurrent();
        return !(lang != null && !lang.equals(l.getLanguage()) || country != null && !country.equals(l.getCountry()));
    }

    public static final Locale setThreadLocal(Locale locale) {
        Locale old = (Locale)_thdLocale.get();
        _thdLocale.set(locale);
        return old;
    }

    public static final Locale getThreadLocal() {
        return (Locale)_thdLocale.get();
    }

    public static final Locale getLocale(String localeString, char separator) {
        Locale locale;
        if (localeString == null) {
            return null;
        }
        if (separator == '\u0000') {
            separator = localeString.indexOf(95) >= 0 ? (char)95 : (localeString.indexOf(45) >= 0 ? (char)45 : (char)44);
        }
        if (!java.util.Objects.equals(localeString = localeString.replace(separator, '-'), (locale = Locale.forLanguageTag(localeString)).toLanguageTag())) {
            String[] split = localeString.split("-");
            switch (split.length) {
                case 1: {
                    locale = new Locale(split[0]);
                    break;
                }
                case 2: {
                    locale = new Locale(split[0], split[1]);
                    break;
                }
                case 3: {
                    locale = new Locale(split[0], split[1], split[2]);
                }
            }
        }
        return Locales.getLocale(locale);
    }

    public static final Locale getLocale(String localeString) {
        return Locales.getLocale(localeString, '\u0000');
    }

    public static final Locale getLocale(Locale locale) {
        return _founds.computeIfAbsent(locale, locale1 -> locale);
    }

    public static Locale getByFallback(Collection<Locale> values, Locale locale) {
        if (values.contains(locale)) {
            return locale;
        }
        String lang = locale.getLanguage();
        String cnty = locale.getCountry();
        String variant = locale.getVariant();
        if (variant != null && !variant.isEmpty() && values.contains(locale = new Locale(lang, cnty))) {
            return locale;
        }
        if (cnty != null && !cnty.isEmpty() && values.contains(locale = new Locale(lang, ""))) {
            return locale;
        }
        Locale rtn = null;
        for (Locale l : values) {
            if (!l.getLanguage().equals(lang)) continue;
            if (variant == null || variant.isEmpty() || Objects.equals(l.getCountry(), cnty)) {
                return l;
            }
            if (rtn != null) continue;
            rtn = l;
        }
        return rtn;
    }

    public static int indexOfUnderline(String s, int j) {
        int k;
        int last = s.length() - 2;
        while ((k = s.indexOf(95, j)) >= 0 && k < last) {
            char cc = s.charAt(k + 1);
            if (cc >= 'a' && cc <= 'z' && (cc = s.charAt(k + 2)) >= 'a' && cc <= 'z' && ((cc = s.charAt(k + 3)) < 'a' || cc > 'z')) {
                return k;
            }
            j = k + 1;
        }
        return -1;
    }

    public static int indexOfUnderline(String s) {
        return Locales.indexOfUnderline(s, 0);
    }

    static {
        Locale[] ls;
        _thdLocale = new InheritableThreadLocal();
        _founds = new ConcurrentHashMap<Locale, Locale>(16);
        for (Locale l : ls = new Locale[]{Locale.TRADITIONAL_CHINESE, Locale.SIMPLIFIED_CHINESE, Locale.ENGLISH, Locale.US, Locale.JAPAN, Locale.JAPANESE, Locale.KOREA, Locale.KOREAN, Locale.FRANCE, Locale.FRENCH, Locale.GERMANY, Locale.GERMAN, Locale.CHINESE}) {
            _founds.put(l, l);
        }
    }
}

