/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.zkoss.zul.AbstractChartModel;
import org.zkoss.zul.HiLoModel;

public class SimpleHiLoModel
extends AbstractChartModel
implements HiLoModel {
    private static final long serialVersionUID = 20091008182747L;
    private Comparable<?> _series;
    private List<HiLoTuple> _hlTuples = new ArrayList<HiLoTuple>(31);

    @Override
    public Comparable<?> getSeries() {
        return this._series;
    }

    @Override
    public void setSeries(Comparable<?> series) {
        this._series = series;
    }

    @Override
    public int getDataCount() {
        return this._hlTuples.size();
    }

    @Override
    public Date getDate(int index) {
        return this._hlTuples.get(index).getDate();
    }

    @Override
    public Number getOpen(int index) {
        return this._hlTuples.get(index).getOpen();
    }

    @Override
    public Number getHigh(int index) {
        return this._hlTuples.get(index).getHigh();
    }

    @Override
    public Number getLow(int index) {
        return this._hlTuples.get(index).getLow();
    }

    @Override
    public Number getClose(int index) {
        return this._hlTuples.get(index).getClose();
    }

    @Override
    public Number getVolume(int index) {
        return this._hlTuples.get(index).getVolume();
    }

    @Override
    public void addValue(Date date, Number open, Number high, Number low, Number close, Number volume) {
        this.addValue(date, open, high, low, close, volume, -1);
    }

    @Override
    public void addValue(Date date, Number open, Number high, Number low, Number close, Number volume, int index) {
        int i = this.addValue0(date, open, high, low, close, volume, index);
        this.fireEvent(1, null, date, 0, i, this._hlTuples.get(i).toNumbers());
    }

    @Override
    public void setValue(Date date, Number open, Number high, Number low, Number close, Number volume, int index) {
        this.removeValue0(index);
        this.addValue0(date, open, high, low, close, volume, index);
        this.fireEvent(0, null, date, 0, index, this._hlTuples.get(index).toNumbers());
    }

    private int addValue0(Date date, Number open, Number high, Number low, Number close, Number volume, int index) {
        int i = index;
        if (index >= 0) {
            this._hlTuples.add(index, new HiLoTuple(date, open, high, low, close, volume));
        } else {
            i = this._hlTuples.size();
            this._hlTuples.add(new HiLoTuple(date, open, high, low, close, volume));
        }
        return i;
    }

    @Override
    public void removeValue(int index) {
        HiLoTuple value = this.removeValue0(index);
        this.fireEvent(2, null, null, 0, index, value.toNumbers());
    }

    private HiLoTuple removeValue0(int index) {
        return this._hlTuples.remove(index);
    }

    @Override
    public void clear() {
        this._hlTuples.clear();
        this.fireEvent(2, null, null, -1, -1, null);
    }

    @Override
    public Object clone() {
        SimpleHiLoModel clone = (SimpleHiLoModel)super.clone();
        if (this._hlTuples != null) {
            clone._hlTuples = new ArrayList<HiLoTuple>(this._hlTuples);
        }
        return clone;
    }

    private static class HiLoTuple
    implements Serializable {
        private static final long serialVersionUID = 20091008182814L;
        private Date _date;
        private Number _open;
        private Number _high;
        private Number _low;
        private Number _close;
        private Number _volume;

        private HiLoTuple(Date date, Number open, Number high, Number low, Number close, Number volume) {
            this._date = date;
            this._open = open;
            this._high = high;
            this._low = low;
            this._close = close;
            this._volume = volume;
        }

        private Number[] toNumbers() {
            return new Number[]{this._open, this._high, this._low, this._close, this._volume};
        }

        private Date getDate() {
            return this._date;
        }

        private Number getOpen() {
            return this._open;
        }

        private Number getHigh() {
            return this._high;
        }

        private Number getLow() {
            return this._low;
        }

        private Number getClose() {
            return this._close;
        }

        private Number getVolume() {
            return this._volume;
        }
    }
}

