/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.zkoss.zul.Treecell;
import org.zkoss.zul.Treecol;
import org.zkoss.zul.Treeitem;

public class TreeitemComparator
implements Comparator,
Serializable {
    private final Treecol _treecol;
    private int _index;
    private final boolean _asc;
    private boolean _igcase;
    private boolean _byval;
    private boolean _maxnull;

    public TreeitemComparator() {
        this(-1, true, true, false, false);
    }

    public TreeitemComparator(int index) {
        this(index, true, true, false, false);
    }

    public TreeitemComparator(int index, boolean ascending, boolean ignoreCase) {
        this(index, ascending, ignoreCase, false, false);
    }

    public TreeitemComparator(int index, boolean ascending, boolean ignoreCase, boolean byValue) {
        this(index, ascending, ignoreCase, byValue, false);
    }

    public TreeitemComparator(int index, boolean ascending, boolean ignoreCase, boolean byValue, boolean nullAsMax) {
        this._treecol = null;
        this._index = index;
        this._asc = ascending;
        this._igcase = ignoreCase;
        this._byval = byValue;
        this._maxnull = nullAsMax;
    }

    public TreeitemComparator(Treecol treecol, boolean ascending, boolean ignoreCase) {
        this(treecol, ascending, ignoreCase, false, false);
    }

    public TreeitemComparator(Treecol treecol, boolean ascending, boolean ignoreCase, boolean byValue) {
        this(treecol, ascending, ignoreCase, byValue, false);
    }

    public TreeitemComparator(Treecol treecol, boolean ascending, boolean ignoreCase, boolean byValue, boolean nullAsMax) {
        this._treecol = treecol;
        this._index = -1;
        this._asc = ascending;
        this._igcase = ignoreCase;
        this._byval = byValue;
        this._maxnull = nullAsMax;
    }

    public Treecol getTreecol() {
        return this._treecol;
    }

    public boolean isAscending() {
        return this._asc;
    }

    public boolean shallIgnoreCase() {
        return this._igcase;
    }

    public boolean byValue() {
        return this._byval;
    }

    public int compare(Object o1, Object o2) {
        Object v2;
        Object v1;
        int index;
        int n = index = this._index < 0 && this._treecol != null ? this._treecol.getColumnIndex() : this._index;
        if (o1 instanceof Treeitem) {
            Treeitem ti1 = (Treeitem)((Object)o1);
            Treeitem ti2 = (Treeitem)((Object)o2);
            if (index < 0) {
                v1 = this.handleCase((Comparable)ti1.getValue());
                v2 = this.handleCase((Comparable)ti2.getValue());
            } else {
                List tcs1 = ti1.getTreerow().getChildren();
                if (index >= tcs1.size()) {
                    v1 = null;
                } else {
                    Treecell tc = (Treecell)((Object)tcs1.get(index));
                    v1 = this.handleCase(this._byval ? ti1.getValue() : tc.getLabel());
                }
                List lcs2 = ti2.getTreerow().getChildren();
                if (index >= lcs2.size()) {
                    v2 = null;
                } else {
                    Treecell lc = (Treecell)((Object)lcs2.get(index));
                    v2 = this.handleCase(this._byval ? ti1.getValue() : lc.getLabel());
                }
            }
        } else {
            v1 = this.handleCase(o1);
            v2 = this.handleCase(o2);
        }
        if (v1 == null) {
            return v2 == null ? 0 : (this._maxnull ? 1 : -1);
        }
        if (v2 == null) {
            return this._maxnull ? -1 : 1;
        }
        int v = ((Comparable)v1).compareTo(v2);
        return this._asc ? v : -v;
    }

    private Object handleCase(Object c) {
        if (this._igcase) {
            if (c instanceof String) {
                return ((String)c).toUpperCase();
            }
            if (c instanceof Character) {
                return new Character(Character.toUpperCase(((Character)c).charValue()));
            }
        }
        return c;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TreeitemComparator)) {
            return false;
        }
        TreeitemComparator c = (TreeitemComparator)o;
        return c._index == this._index && c._asc == this._asc && c._igcase == this._igcase;
    }

    public int hashCode() {
        return this._index ^ (this._asc ? 1 : 5) ^ (this._igcase ? 9 : 3);
    }

    public String toString() {
        return "[Comparator " + this._index + "-th col, asc:" + this._asc + "]";
    }
}

