/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.annotation.processing.rest.jaxrs;

import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.apache.dubbo.common.utils.PathUtils;
import org.apache.dubbo.metadata.annotation.processing.rest.AbstractServiceRestMetadataResolver;
import org.apache.dubbo.metadata.annotation.processing.util.AnnotationUtils;

public class JAXRSServiceRestMetadataResolver
extends AbstractServiceRestMetadataResolver {
    @Override
    public boolean supports(ProcessingEnvironment processingEnvironment, TypeElement serviceType) {
        return JAXRSServiceRestMetadataResolver.supports(serviceType);
    }

    public static boolean supports(TypeElement serviceType) {
        return AnnotationUtils.isAnnotationPresent(serviceType, "javax.ws.rs.Path");
    }

    @Override
    protected boolean supports(ProcessingEnvironment processingEnv, TypeElement serviceType, TypeElement serviceInterfaceType, ExecutableElement method) {
        return AnnotationUtils.isAnnotationPresent(method, "javax.ws.rs.Path") || AnnotationUtils.isAnnotationPresent(method, "javax.ws.rs.HttpMethod");
    }

    @Override
    protected String resolveRequestPath(ProcessingEnvironment processingEnv, TypeElement serviceType, ExecutableElement method) {
        String pathFromType = this.getPathValue(processingEnv, serviceType);
        String pathFromMethod = this.getPathValue(method);
        return PathUtils.buildPath((String)pathFromType, (String[])new String[]{pathFromMethod});
    }

    @Override
    protected String resolveRequestMethod(ProcessingEnvironment processingEnv, TypeElement serviceType, ExecutableElement method) {
        AnnotationMirror annotation = AnnotationUtils.findMetaAnnotation(method, "javax.ws.rs.HttpMethod");
        return (String)AnnotationUtils.getValue(annotation);
    }

    @Override
    protected void processProduces(ProcessingEnvironment processingEnv, TypeElement serviceType, ExecutableElement method, Set<String> produces) {
        this.addAnnotationValues(method, "javax.ws.rs.Produces", produces);
    }

    @Override
    protected void processConsumes(ProcessingEnvironment processingEnv, TypeElement serviceType, ExecutableElement method, Set<String> consumes) {
        this.addAnnotationValues(method, "javax.ws.rs.Consumes", consumes);
    }

    private void addAnnotationValues(Element element, String annotationAttributeName, Set<String> result) {
        AnnotationMirror annotation = AnnotationUtils.findAnnotation(element, (CharSequence)annotationAttributeName);
        String[] value = (String[])AnnotationUtils.getValue(annotation);
        if (value != null) {
            Stream.of(value).forEach(result::add);
        }
    }

    private String getPathValue(ProcessingEnvironment processingEnv, TypeElement serviceType) {
        AnnotationMirror annotation = AnnotationUtils.findAnnotation((Element)serviceType, (CharSequence)"javax.ws.rs.Path");
        return (String)AnnotationUtils.getValue(annotation);
    }

    private String getPathValue(AnnotatedConstruct annotatedConstruct) {
        AnnotationMirror annotation = AnnotationUtils.getAnnotation(annotatedConstruct, "javax.ws.rs.Path");
        return (String)AnnotationUtils.getValue(annotation);
    }
}

