/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.utils;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassFinder {
    public Set<String> findClassSet(String packageName) {
        packageName = packageName.replace(".", "/");
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> resources = classLoader.getResources(packageName);
            HashSet<String> result = new HashSet<String>();
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                if (resource == null) continue;
                String protocol = resource.getProtocol();
                if ("file".equals(protocol)) {
                    this.findClassesByFile(packageName, resource.getPath(), result);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                JarFile jar = ((JarURLConnection)resource.openConnection()).getJarFile();
                System.out.println("findClassSet jar:" + jar.getName());
                ClassFinder.findClassesByJar(packageName, jar, result);
            }
            return result;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private void findClassesByFile(String packageName, String resource, Set<String> result) {
        File directory = new File(resource);
        File[] listFiles = directory.listFiles();
        if (listFiles != null) {
            for (File file : listFiles) {
                if (file.isDirectory()) {
                    this.findClassesByFile(packageName, file.getPath(), result);
                    continue;
                }
                String path = file.getPath();
                if (!path.endsWith(".class")) continue;
                int packageIndex = path.indexOf(packageName.replace("/", File.separator));
                String classPath = path.substring(packageIndex, path.length() - 6);
                result.add(classPath.replace(File.separator, "."));
            }
        }
    }

    private static void findClassesByJar(String packageName, JarFile jar, Set<String> classes) {
        Enumeration<JarEntry> entry = jar.entries();
        while (entry.hasMoreElements()) {
            JarEntry jarEntry = entry.nextElement();
            String name = jarEntry.getName();
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            if (jarEntry.isDirectory() || !name.startsWith(packageName) || !name.endsWith(".class")) continue;
            String className = name.substring(0, name.length() - 6);
            classes.add(className.replace("/", "."));
        }
    }
}

