/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.dubbo.common.extension.Adaptive;
import org.apache.dubbo.common.extension.AdaptiveClassCodeGenerator;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.utils.ClassFinder;

public class CodeGenerator {
    private static String licensedStr = "/*\n * Licensed to the Apache Software Foundation (ASF) under one or more\n * contributor license agreements.  See the NOTICE file distributed with\n * this work for additional information regarding copyright ownership.\n * The ASF licenses this file to You under the Apache License, Version 2.0\n * (the \"License\"); you may not use this file except in compliance with\n * the License.  You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n";

    public static void main(String[] args) {
        URL r = Thread.currentThread().getContextClassLoader().getResource("");
        String targetClassPath = new File(r.getFile()).getAbsolutePath();
        String p = Paths.get(targetClassPath, new String[0]).getParent().getParent().toString() + File.separator + "src" + File.separator + "main" + File.separator + "java";
        System.out.println(p);
        List classes = new ClassFinder().findClassSet("org.apache.dubbo").stream().map(it -> {
            try {
                return Class.forName(it);
            }
            catch (Throwable throwable) {
                return null;
            }
        }).collect(Collectors.toList());
        new ArrayList(classes).stream().filter(it -> {
            if (null == it) {
                return false;
            }
            SPI anno = it.getAnnotation(SPI.class);
            if (null == anno) {
                return false;
            }
            Optional<Method> optional = Arrays.stream(it.getMethods()).filter(it2 -> it2.getAnnotation(Adaptive.class) != null).findAny();
            return optional.isPresent();
        }).forEach(it -> {
            SPI spi = it.getAnnotation(SPI.class);
            String value = spi.value();
            if (StringUtils.isEmpty((String)value)) {
                value = "adaptive";
            }
            AdaptiveClassCodeGenerator codeGenerator = new AdaptiveClassCodeGenerator(it, value);
            String code = codeGenerator.generate(true);
            System.out.println(code);
            System.out.println("-----:" + it.getPackage());
            try {
                String file = p + File.separator + it.getName().replaceAll("\\.", Matcher.quoteReplacement(File.separator));
                String dir = Paths.get(file, new String[0]).getParent().toString();
                FileUtils.forceMkdir((File)new File(dir));
                code = licensedStr + code + "\n";
                FileUtils.write((File)new File(file + "$Adaptive.java"), (CharSequence)code, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        System.out.println(classes.size());
    }
}

