/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.prepare;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.model.ModelHandler;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.schema.AggregateFunction;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.ScalarFunction;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableFunction;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.Wrapper;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.FamilyOperandTypeChecker;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.ListSqlOperatorTable;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlMonikerImpl;
import org.apache.calcite.sql.validate.SqlMonikerType;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.sql.validate.SqlUserDefinedAggFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedTableMacro;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Util;

public class CalciteCatalogReader
implements Prepare.CatalogReader {
    protected final CalciteSchema rootSchema;
    protected final RelDataTypeFactory typeFactory;
    private final List<List<String>> schemaPaths;
    protected final SqlNameMatcher nameMatcher;
    protected final CalciteConnectionConfig config;

    public CalciteCatalogReader(CalciteSchema rootSchema, List<String> defaultSchema, RelDataTypeFactory typeFactory, CalciteConnectionConfig config) {
        this(rootSchema, SqlNameMatchers.withCaseSensitive(config != null && config.caseSensitive()), (List<List<String>>)ImmutableList.of(Objects.requireNonNull(defaultSchema), (Object)ImmutableList.of()), typeFactory, config);
    }

    protected CalciteCatalogReader(CalciteSchema rootSchema, SqlNameMatcher nameMatcher, List<List<String>> schemaPaths, RelDataTypeFactory typeFactory, CalciteConnectionConfig config) {
        this.rootSchema = Objects.requireNonNull(rootSchema);
        this.nameMatcher = nameMatcher;
        this.schemaPaths = Util.immutableCopy(Util.isDistinct(schemaPaths) ? schemaPaths : new LinkedHashSet<List<String>>(schemaPaths));
        this.typeFactory = typeFactory;
        this.config = config;
    }

    @Override
    public CalciteCatalogReader withSchemaPath(List<String> schemaPath) {
        return new CalciteCatalogReader(this.rootSchema, this.nameMatcher, (List<List<String>>)ImmutableList.of(schemaPath, (Object)ImmutableList.of()), this.typeFactory, this.config);
    }

    @Override
    public Prepare.PreparingTable getTable(List<String> names) {
        CalciteSchema.TableEntry entry = SqlValidatorUtil.getTableEntry(this, names);
        if (entry != null) {
            Prepare.PreparingTable relOptTable;
            Table table = entry.getTable();
            if (table instanceof Wrapper && (relOptTable = ((Wrapper)((Object)table)).unwrap(Prepare.PreparingTable.class)) != null) {
                return relOptTable;
            }
            return RelOptTableImpl.create((RelOptSchema)this, table.getRowType(this.typeFactory), entry, null);
        }
        return null;
    }

    @Override
    public CalciteConnectionConfig getConfig() {
        return this.config;
    }

    private Collection<Function> getFunctionsFrom(List<String> names) {
        CalciteSchema schema;
        ArrayList<Function> functions2 = new ArrayList<Function>();
        ArrayList<List<String>> schemaNameList = new ArrayList<List<String>>();
        if (names.size() > 1) {
            if (this.schemaPaths.size() > 1) {
                schemaNameList.addAll(Util.skip(this.schemaPaths));
            } else {
                schemaNameList.addAll(this.schemaPaths);
            }
        } else {
            for (List<String> schemaPath : this.schemaPaths) {
                schema = SqlValidatorUtil.getSchema(this.rootSchema, schemaPath, this.nameMatcher);
                if (schema == null) continue;
                schemaNameList.addAll(schema.getPath());
            }
        }
        for (List<String> schemaNames : schemaNameList) {
            schema = SqlValidatorUtil.getSchema(this.rootSchema, Iterables.concat(schemaNames, Util.skipLast(names)), this.nameMatcher);
            if (schema == null) continue;
            String name = Util.last(names);
            functions2.addAll(schema.getFunctions(name, true));
        }
        return functions2;
    }

    @Override
    public RelDataType getNamedType(SqlIdentifier typeName) {
        CalciteSchema.TypeEntry typeEntry = SqlValidatorUtil.getTypeEntry(this.getRootSchema(), typeName);
        if (typeEntry != null) {
            return (RelDataType)typeEntry.getType().apply(this.typeFactory);
        }
        return null;
    }

    @Override
    public List<SqlMoniker> getAllSchemaObjectNames(List<String> names) {
        CalciteSchema schema = SqlValidatorUtil.getSchema(this.rootSchema, names, this.nameMatcher);
        if (schema == null) {
            return ImmutableList.of();
        }
        ArrayList<SqlMoniker> result = new ArrayList<SqlMoniker>();
        if (!schema.name.equals("")) {
            result.add(this.moniker(schema, null, SqlMonikerType.SCHEMA));
        }
        NavigableMap<String, CalciteSchema> schemaMap = schema.getSubSchemaMap();
        for (String subSchema : schemaMap.keySet()) {
            result.add(this.moniker(schema, subSchema, SqlMonikerType.SCHEMA));
        }
        for (String table : schema.getTableNames()) {
            result.add(this.moniker(schema, table, SqlMonikerType.TABLE));
        }
        NavigableSet<String> functions = schema.getFunctionNames();
        for (String function : functions) {
            result.add(this.moniker(schema, function, SqlMonikerType.FUNCTION));
        }
        return result;
    }

    private SqlMonikerImpl moniker(CalciteSchema schema, String name, SqlMonikerType type) {
        List<String> path = schema.path(name);
        if (path.size() == 1 && !schema.root().name.equals("") && type == SqlMonikerType.SCHEMA) {
            type = SqlMonikerType.CATALOG;
        }
        return new SqlMonikerImpl(path, type);
    }

    @Override
    public List<List<String>> getSchemaPaths() {
        return this.schemaPaths;
    }

    @Override
    public Prepare.PreparingTable getTableForMember(List<String> names) {
        return this.getTable((List)names);
    }

    @Override
    public RelDataTypeField field(RelDataType rowType, String alias) {
        return this.nameMatcher.field(rowType, alias);
    }

    @Override
    public boolean matches(String string, String name) {
        return this.nameMatcher.matches(string, name);
    }

    @Override
    public RelDataType createTypeFromProjection(RelDataType type, List<String> columnNameList) {
        return SqlValidatorUtil.createTypeFromProjection(type, columnNameList, this.typeFactory, this.nameMatcher.isCaseSensitive());
    }

    @Override
    public void lookupOperatorOverloads(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList) {
        if (syntax != SqlSyntax.FUNCTION) {
            return;
        }
        Predicate<Function> predicate = category == null ? function -> true : (category.isTableFunction() ? function -> function instanceof TableMacro || function instanceof TableFunction : function -> !(function instanceof TableMacro) && !(function instanceof TableFunction));
        this.getFunctionsFrom((List<String>)opName.names).stream().filter(predicate).map(function -> this.toOp(opName, (Function)function)).forEachOrdered(operatorList::add);
    }

    public static SqlOperatorTable operatorTable(String className) {
        CalciteSchema schema = CalciteSchema.createRootSchema(false, false);
        ModelHandler.addFunctions(schema.plus(), null, (List<String>)ImmutableList.of(), className, "*", true);
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        ListSqlOperatorTable table = new ListSqlOperatorTable();
        for (String name : schema.getFunctionNames()) {
            for (Function function : schema.getFunctions(name, true)) {
                SqlIdentifier id = new SqlIdentifier(name, SqlParserPos.ZERO);
                table.add(CalciteCatalogReader.toOp(typeFactory, id, function));
            }
        }
        return table;
    }

    private SqlOperator toOp(SqlIdentifier name, Function function) {
        return CalciteCatalogReader.toOp(this.typeFactory, name, function);
    }

    private static SqlOperator toOp(RelDataTypeFactory typeFactory, SqlIdentifier name, Function function) {
        ArrayList<RelDataType> argTypes = new ArrayList<RelDataType>();
        ArrayList<SqlTypeFamily> typeFamilies = new ArrayList<SqlTypeFamily>();
        for (FunctionParameter o : function.getParameters()) {
            RelDataType type = o.getType(typeFactory);
            argTypes.add(type);
            typeFamilies.add(Util.first(type.getSqlTypeName().getFamily(), SqlTypeFamily.ANY));
        }
        FamilyOperandTypeChecker typeChecker = OperandTypes.family(typeFamilies, i -> function.getParameters().get((int)i).isOptional());
        List<RelDataType> paramTypes = CalciteCatalogReader.toSql(typeFactory, argTypes);
        if (function instanceof ScalarFunction) {
            return new SqlUserDefinedFunction(name, CalciteCatalogReader.infer((ScalarFunction)function), InferTypes.explicit(argTypes), (SqlOperandTypeChecker)typeChecker, paramTypes, function);
        }
        if (function instanceof AggregateFunction) {
            return new SqlUserDefinedAggFunction(name, CalciteCatalogReader.infer((AggregateFunction)function), InferTypes.explicit(argTypes), typeChecker, (AggregateFunction)function, false, false, typeFactory);
        }
        if (function instanceof TableMacro) {
            return new SqlUserDefinedTableMacro(name, ReturnTypes.CURSOR, InferTypes.explicit(argTypes), (SqlOperandTypeChecker)typeChecker, paramTypes, (TableMacro)function);
        }
        if (function instanceof TableFunction) {
            return new SqlUserDefinedTableFunction(name, ReturnTypes.CURSOR, InferTypes.explicit(argTypes), (SqlOperandTypeChecker)typeChecker, paramTypes, (TableFunction)function);
        }
        throw new AssertionError((Object)("unknown function type " + function));
    }

    private static SqlReturnTypeInference infer(ScalarFunction function) {
        return opBinding -> {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType type = function instanceof ScalarFunctionImpl ? ((ScalarFunctionImpl)function).getReturnType(typeFactory, opBinding) : function.getReturnType(typeFactory);
            return CalciteCatalogReader.toSql(typeFactory, type);
        };
    }

    private static SqlReturnTypeInference infer(AggregateFunction function) {
        return opBinding -> {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType type = function.getReturnType(typeFactory);
            return CalciteCatalogReader.toSql(typeFactory, type);
        };
    }

    private static List<RelDataType> toSql(RelDataTypeFactory typeFactory, List<RelDataType> types) {
        return Lists.transform(types, type -> CalciteCatalogReader.toSql(typeFactory, type));
    }

    private static RelDataType toSql(RelDataTypeFactory typeFactory, RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType && ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass() == Object.class) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true);
        }
        return JavaTypeFactoryImpl.toSql(typeFactory, type);
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        return null;
    }

    @Override
    public CalciteSchema getRootSchema() {
        return this.rootSchema;
    }

    @Override
    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public void registerRules(RelOptPlanner planner) throws Exception {
    }

    @Override
    public boolean isCaseSensitive() {
        return this.nameMatcher.isCaseSensitive();
    }

    @Override
    public SqlNameMatcher nameMatcher() {
        return this.nameMatcher;
    }

    @Override
    public <C> C unwrap(Class<C> aClass) {
        if (aClass.isInstance(this)) {
            return aClass.cast(this);
        }
        return null;
    }
}

