/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.type;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.rel.type.RelCrossType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.type.JavaToSqlTypeConversionRules;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Util;

public abstract class RelDataTypeFactoryImpl
implements RelDataTypeFactory {
    private static final LoadingCache<Object, RelDataType> CACHE = CacheBuilder.newBuilder().softValues().build(CacheLoader.from(RelDataTypeFactoryImpl::keyToType));
    private static final Map<Class, RelDataTypeFamily> CLASS_FAMILIES = ImmutableMap.builder().put(String.class, (Object)SqlTypeFamily.CHARACTER).put(byte[].class, (Object)SqlTypeFamily.BINARY).put(Boolean.TYPE, (Object)SqlTypeFamily.BOOLEAN).put(Boolean.class, (Object)SqlTypeFamily.BOOLEAN).put(Character.TYPE, (Object)SqlTypeFamily.NUMERIC).put(Character.class, (Object)SqlTypeFamily.NUMERIC).put(Short.TYPE, (Object)SqlTypeFamily.NUMERIC).put(Short.class, (Object)SqlTypeFamily.NUMERIC).put(Integer.TYPE, (Object)SqlTypeFamily.NUMERIC).put(Integer.class, (Object)SqlTypeFamily.NUMERIC).put(Long.TYPE, (Object)SqlTypeFamily.NUMERIC).put(Long.class, (Object)SqlTypeFamily.NUMERIC).put(Float.TYPE, (Object)SqlTypeFamily.APPROXIMATE_NUMERIC).put(Float.class, (Object)SqlTypeFamily.APPROXIMATE_NUMERIC).put(Double.TYPE, (Object)SqlTypeFamily.APPROXIMATE_NUMERIC).put(Double.class, (Object)SqlTypeFamily.APPROXIMATE_NUMERIC).put(Date.class, (Object)SqlTypeFamily.DATE).put(Time.class, (Object)SqlTypeFamily.TIME).put(Timestamp.class, (Object)SqlTypeFamily.TIMESTAMP).build();
    protected final RelDataTypeSystem typeSystem;

    private static RelDataType keyToType(@Nonnull Object k) {
        if (k instanceof RelDataType) {
            return (RelDataType)k;
        }
        Key key = (Key)k;
        ImmutableList.Builder list = ImmutableList.builder();
        for (int i = 0; i < key.names.size(); ++i) {
            list.add((Object)new RelDataTypeFieldImpl((String)key.names.get(i), i, (RelDataType)key.types.get(i)));
        }
        return new RelRecordType(key.kind, (List<RelDataTypeField>)list.build());
    }

    protected RelDataTypeFactoryImpl(RelDataTypeSystem typeSystem) {
        this.typeSystem = Objects.requireNonNull(typeSystem);
    }

    @Override
    public RelDataTypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    @Override
    public RelDataType createJavaType(Class clazz) {
        JavaType javaType = clazz == String.class ? new JavaType(clazz, true, this.getDefaultCharset(), SqlCollation.IMPLICIT) : new JavaType(clazz);
        return this.canonize(javaType);
    }

    @Override
    public RelDataType createJoinType(RelDataType ... types) {
        assert (types != null);
        assert (types.length >= 1);
        ArrayList<RelDataType> flattenedTypes = new ArrayList<RelDataType>();
        RelDataTypeFactoryImpl.getTypeList((ImmutableList<RelDataType>)ImmutableList.copyOf((Object[])types), flattenedTypes);
        return this.canonize(new RelCrossType(flattenedTypes, RelDataTypeFactoryImpl.getFieldList(flattenedTypes)));
    }

    @Override
    public RelDataType createStructType(List<RelDataType> typeList, List<String> fieldNameList) {
        return this.createStructType(StructKind.FULLY_QUALIFIED, typeList, fieldNameList);
    }

    @Override
    public RelDataType createStructType(StructKind kind, List<RelDataType> typeList, List<String> fieldNameList) {
        assert (typeList.size() == fieldNameList.size());
        return this.canonize(kind, fieldNameList, typeList);
    }

    @Override
    public RelDataType createStructType(final RelDataTypeFactory.FieldInfo fieldInfo) {
        return this.canonize(StructKind.FULLY_QUALIFIED, (List<String>)new AbstractList<String>(){

            @Override
            public String get(int index) {
                return fieldInfo.getFieldName(index);
            }

            @Override
            public int size() {
                return fieldInfo.getFieldCount();
            }
        }, (List<RelDataType>)new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                return fieldInfo.getFieldType(index);
            }

            @Override
            public int size() {
                return fieldInfo.getFieldCount();
            }
        });
    }

    @Override
    public final RelDataType createStructType(final List<? extends Map.Entry<String, RelDataType>> fieldList) {
        return this.canonize(StructKind.FULLY_QUALIFIED, (List<String>)new AbstractList<String>(){

            @Override
            public String get(int index) {
                return (String)((Map.Entry)fieldList.get(index)).getKey();
            }

            @Override
            public int size() {
                return fieldList.size();
            }
        }, (List<RelDataType>)new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                return (RelDataType)((Map.Entry)fieldList.get(index)).getValue();
            }

            @Override
            public int size() {
                return fieldList.size();
            }
        });
    }

    @Override
    public RelDataType leastRestrictive(List<RelDataType> types) {
        assert (types != null);
        assert (types.size() >= 1);
        RelDataType type0 = types.get(0);
        if (type0.isStruct()) {
            return this.leastRestrictiveStructuredType(types);
        }
        return null;
    }

    protected RelDataType leastRestrictiveStructuredType(final List<RelDataType> types) {
        RelDataType type0 = types.get(0);
        int fieldCount = type0.getFieldCount();
        for (RelDataType type : types) {
            if (!type.isStruct()) {
                return null;
            }
            if (type.getFieldList().size() == fieldCount) continue;
            return null;
        }
        RelDataTypeFactory.FieldInfoBuilder builder = this.builder();
        for (int j = 0; j < fieldCount; ++j) {
            final int k = j;
            ((RelDataTypeFactory.Builder)builder).add(type0.getFieldList().get(j).getName(), this.leastRestrictive((List<RelDataType>)new AbstractList<RelDataType>(){

                @Override
                public RelDataType get(int index) {
                    return ((RelDataType)types.get(index)).getFieldList().get(k).getType();
                }

                @Override
                public int size() {
                    return types.size();
                }
            }));
        }
        return builder.build();
    }

    private RelDataType copySimpleType(RelDataType type, boolean nullable) {
        if (type instanceof JavaType) {
            JavaType javaType = (JavaType)type;
            if (SqlTypeUtil.inCharFamily(javaType)) {
                return new JavaType(javaType.clazz, nullable, javaType.charset, javaType.collation);
            }
            return new JavaType(nullable ? Primitive.box((Class)javaType.clazz) : Primitive.unbox((Class)javaType.clazz), nullable);
        }
        return type;
    }

    private RelDataType copyRecordType(final RelRecordType type, final boolean ignoreNullable, final boolean nullable) {
        return this.createStructType(type.getStructKind(), (List<RelDataType>)new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                RelDataType fieldType = type.getFieldList().get(index).getType();
                if (ignoreNullable) {
                    return RelDataTypeFactoryImpl.this.copyType(fieldType);
                }
                return RelDataTypeFactoryImpl.this.createTypeWithNullability(fieldType, nullable);
            }

            @Override
            public int size() {
                return type.getFieldCount();
            }
        }, type.getFieldNames());
    }

    @Override
    public RelDataType copyType(RelDataType type) {
        if (type instanceof RelRecordType) {
            return this.copyRecordType((RelRecordType)type, true, false);
        }
        return this.createTypeWithNullability(type, type.isNullable());
    }

    @Override
    public RelDataType createTypeWithNullability(RelDataType type, boolean nullable) {
        Objects.requireNonNull(type);
        RelDataType newType = type.isNullable() == nullable ? type : (type instanceof RelRecordType ? (nullable ? this.copyRecordType((RelRecordType)type, false, true) : this.copyRecordType((RelRecordType)type, true, false)) : this.copySimpleType(type, nullable));
        return this.canonize(newType);
    }

    protected RelDataType canonize(RelDataType type) {
        return (RelDataType)CACHE.getUnchecked((Object)type);
    }

    protected RelDataType canonize(StructKind kind, List<String> names, List<RelDataType> types) {
        RelDataType type = (RelDataType)CACHE.getIfPresent((Object)new Key(kind, names, types));
        if (type != null) {
            return type;
        }
        ImmutableList names2 = ImmutableList.copyOf(names);
        ImmutableList types2 = ImmutableList.copyOf(types);
        return (RelDataType)CACHE.getUnchecked((Object)new Key(kind, (List<String>)names2, (List<RelDataType>)types2));
    }

    private static List<RelDataTypeField> getFieldList(List<RelDataType> types) {
        ArrayList<RelDataTypeField> fieldList = new ArrayList<RelDataTypeField>();
        for (RelDataType type : types) {
            RelDataTypeFactoryImpl.addFields(type, fieldList);
        }
        return fieldList;
    }

    private static void getTypeList(ImmutableList<RelDataType> inTypes, List<RelDataType> flatTypes) {
        for (RelDataType inType : inTypes) {
            if (inType instanceof RelCrossType) {
                RelDataTypeFactoryImpl.getTypeList(((RelCrossType)inType).types, flatTypes);
                continue;
            }
            flatTypes.add(inType);
        }
    }

    private static void addFields(RelDataType type, List<RelDataTypeField> fieldList) {
        if (type instanceof RelCrossType) {
            RelCrossType crossType = (RelCrossType)type;
            for (RelDataType type1 : crossType.types) {
                RelDataTypeFactoryImpl.addFields(type1, fieldList);
            }
        } else {
            List<RelDataTypeField> fields = type.getFieldList();
            for (RelDataTypeField field : fields) {
                if (field.getIndex() != fieldList.size()) {
                    field = new RelDataTypeFieldImpl(field.getName(), fieldList.size(), field.getType());
                }
                fieldList.add(field);
            }
        }
    }

    public static boolean isJavaType(RelDataType t) {
        return t instanceof JavaType;
    }

    private List<RelDataTypeFieldImpl> fieldsOf(Class clazz) {
        ArrayList<RelDataTypeFieldImpl> list = new ArrayList<RelDataTypeFieldImpl>();
        for (Field field : clazz.getFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            list.add(new RelDataTypeFieldImpl(field.getName(), list.size(), this.createJavaType(field.getType())));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    @Override
    public RelDataType createDecimalProduct(RelDataType type1, RelDataType type2) {
        if (SqlTypeUtil.isExactNumeric(type1) && SqlTypeUtil.isExactNumeric(type2) && (SqlTypeUtil.isDecimal(type1) || SqlTypeUtil.isDecimal(type2))) {
            int p1 = type1.getPrecision();
            int p2 = type2.getPrecision();
            int s1 = type1.getScale();
            int s2 = type2.getScale();
            int scale = s1 + s2;
            scale = Math.min(scale, this.typeSystem.getMaxNumericScale());
            int precision = p1 + p2;
            precision = Math.min(precision, this.typeSystem.getMaxNumericPrecision());
            RelDataType ret = this.createSqlType(SqlTypeName.DECIMAL, precision, scale);
            return ret;
        }
        return null;
    }

    @Override
    public boolean useDoubleMultiplication(RelDataType type1, RelDataType type2) {
        assert (this.createDecimalProduct(type1, type2) != null);
        return false;
    }

    @Override
    public RelDataType createDecimalQuotient(RelDataType type1, RelDataType type2) {
        if (SqlTypeUtil.isExactNumeric(type1) && SqlTypeUtil.isExactNumeric(type2) && (SqlTypeUtil.isDecimal(type1) || SqlTypeUtil.isDecimal(type2))) {
            int p1 = type1.getPrecision();
            int p2 = type2.getPrecision();
            int s1 = type1.getScale();
            int s2 = type2.getScale();
            int maxNumericPrecision = this.typeSystem.getMaxNumericPrecision();
            int dout = Math.min(p1 - s1 + s2, maxNumericPrecision);
            int scale = Math.max(6, s1 + p2 + 1);
            scale = Math.min(scale, maxNumericPrecision - dout);
            scale = Math.min(scale, this.getTypeSystem().getMaxNumericScale());
            int precision = dout + scale;
            assert (precision <= maxNumericPrecision);
            assert (precision > 0);
            RelDataType ret = this.createSqlType(SqlTypeName.DECIMAL, precision, scale);
            return ret;
        }
        return null;
    }

    @Override
    public RelDataType decimalOf(RelDataType type) {
        Preconditions.checkArgument((SqlTypeUtil.isNumeric(type) || SqlTypeUtil.isNull(type) ? 1 : 0) != 0);
        SqlTypeName typeName = type.getSqlTypeName();
        assert (typeName != null);
        switch (typeName) {
            case DECIMAL: {
                return type;
            }
            case TINYINT: {
                return this.createSqlType(SqlTypeName.DECIMAL, 3, 0);
            }
            case SMALLINT: {
                return this.createSqlType(SqlTypeName.DECIMAL, 5, 0);
            }
            case INTEGER: {
                return this.createSqlType(SqlTypeName.DECIMAL, 10, 0);
            }
            case BIGINT: {
                return this.createSqlType(SqlTypeName.DECIMAL, 38, 0);
            }
            case REAL: {
                return this.createSqlType(SqlTypeName.DECIMAL, 14, 7);
            }
            case FLOAT: {
                return this.createSqlType(SqlTypeName.DECIMAL, 14, 7);
            }
            case DOUBLE: {
                return this.createSqlType(SqlTypeName.DECIMAL, 30, 15);
            }
        }
        return this.createSqlType(SqlTypeName.DECIMAL);
    }

    @Override
    public Charset getDefaultCharset() {
        return Util.getDefaultCharset();
    }

    @Override
    public RelDataTypeFactory.FieldInfoBuilder builder() {
        return new RelDataTypeFactory.FieldInfoBuilder(this);
    }

    private static class Key {
        private final StructKind kind;
        private final List<String> names;
        private final List<RelDataType> types;

        Key(StructKind kind, List<String> names, List<RelDataType> types) {
            this.kind = kind;
            this.names = names;
            this.types = types;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.names, this.types});
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Key && this.kind == ((Key)obj).kind && this.names.equals(((Key)obj).names) && this.types.equals(((Key)obj).types);
        }
    }

    public class JavaType
    extends RelDataTypeImpl {
        private final Class clazz;
        private final boolean nullable;
        private SqlCollation collation;
        private Charset charset;

        public JavaType(Class clazz) {
            this(clazz, !clazz.isPrimitive());
        }

        public JavaType(Class clazz, boolean nullable) {
            this(clazz, nullable, null, null);
        }

        public JavaType(Class clazz, boolean nullable, Charset charset, SqlCollation collation) {
            super(RelDataTypeFactoryImpl.this.fieldsOf(clazz));
            this.clazz = clazz;
            this.nullable = nullable;
            assert (charset != null == SqlTypeUtil.inCharFamily(this)) : "Need to be a chartype";
            this.charset = charset;
            this.collation = collation;
            this.computeDigest();
        }

        public Class getJavaClass() {
            return this.clazz;
        }

        @Override
        public boolean isNullable() {
            return this.nullable;
        }

        @Override
        public RelDataTypeFamily getFamily() {
            RelDataTypeFamily family = (RelDataTypeFamily)CLASS_FAMILIES.get(this.clazz);
            return family != null ? family : this;
        }

        @Override
        protected void generateTypeString(StringBuilder sb, boolean withDetail) {
            sb.append("JavaType(");
            sb.append(this.clazz);
            sb.append(")");
        }

        @Override
        public RelDataType getComponentType() {
            Class<?> componentType = this.clazz.getComponentType();
            if (componentType == null) {
                return null;
            }
            return RelDataTypeFactoryImpl.this.createJavaType(componentType);
        }

        @Override
        public Charset getCharset() {
            return this.charset;
        }

        @Override
        public SqlCollation getCollation() {
            return this.collation;
        }

        @Override
        public SqlTypeName getSqlTypeName() {
            SqlTypeName typeName = JavaToSqlTypeConversionRules.instance().lookup(this.clazz);
            if (typeName == null) {
                return SqlTypeName.OTHER;
            }
            return typeName;
        }
    }
}

