/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlSnapshot
extends SqlCall {
    private static final int OPERAND_TABLE_REF = 0;
    private static final int OPERAND_PERIOD = 1;
    private SqlNode tableRef;
    private SqlNode period;

    public SqlSnapshot(SqlParserPos pos, SqlNode tableRef, SqlNode period) {
        super(pos);
        this.tableRef = tableRef;
        this.period = period;
        assert (tableRef != null);
        assert (period != null);
    }

    @Override
    public SqlOperator getOperator() {
        return SqlSnapshotOperator.INSTANCE;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.tableRef, this.period);
    }

    public SqlNode getTableRef() {
        return this.tableRef;
    }

    public SqlNode getPeriod() {
        return this.period;
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                this.tableRef = operand;
                break;
            }
            case 1: {
                this.period = operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.getOperator().unparse(writer, this, 0, 0);
    }

    public static class SqlSnapshotOperator
    extends SqlOperator {
        public static final SqlSnapshotOperator INSTANCE = new SqlSnapshotOperator();

        private SqlSnapshotOperator() {
            super("SNAPSHOT", SqlKind.SNAPSHOT, 2, true, null, null, null);
        }

        @Override
        public SqlSyntax getSyntax() {
            return SqlSyntax.SPECIAL;
        }

        @Override
        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            assert (functionQualifier == null);
            assert (operands.length == 2);
            return new SqlSnapshot(pos, operands[0], operands[1]);
        }

        @Override
        public <R> void acceptCall(SqlVisitor<R> visitor, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
            if (onlyExpressions) {
                List<SqlNode> operands = call.getOperandList();
                for (int i = 1; i < operands.size(); ++i) {
                    argHandler.visitChild(visitor, call, i, operands.get(i));
                }
            } else {
                super.acceptCall(visitor, call, false, argHandler);
            }
        }

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlSnapshot temporal = (SqlSnapshot)call;
            temporal.tableRef.unparse(writer, 0, 0);
            writer.keyword("FOR SYSTEM_TIME AS OF");
            temporal.period.unparse(writer, 0, 0);
        }
    }
}

